"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
function getContextClassForStatus(status) {
    switch (status) {
        case "Killed" /* Killed */:
            return 'success';
        case "NoCoverage" /* NoCoverage */:
        case "Survived" /* Survived */:
            return 'danger';
        case "Timeout" /* Timeout */:
            return 'warning';
        case "RuntimeError" /* RuntimeError */:
        case "CompileError" /* CompileError */:
            return 'secondary';
    }
}
exports.getContextClassForStatus = getContextClassForStatus;
function escapeHtml(unsafe) {
    return unsafe
        .replace(/&/g, '&amp;')
        .replace(/</g, '&lt;')
        .replace(/>/g, '&gt;')
        .replace(/"/g, '&quot;')
        .replace(/'/g, '&#039;');
}
exports.escapeHtml = escapeHtml;
//# sourceMappingURL=htmlHelpers.js.map