"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ResultModel_1 = require("./ResultModel");
class DirectoryResultModel extends ResultModel_1.ResultModel {
    constructor(name, path, numbers, childResults) {
        super(name, path, numbers);
        this.childResults = childResults;
        this.representsFile = false;
    }
    find(path) {
        if (path === this.path) {
            return this;
        }
        else if (path.startsWith(this.path)) {
            const child = this.childResults.find(child => path.startsWith(child.path));
            if (child) {
                return child.find(path);
            }
        }
        return undefined;
    }
}
exports.DirectoryResultModel = DirectoryResultModel;
//# sourceMappingURL=DirectoryResultModel.js.map