"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const DEFAULT_SCORE = 100;
class TotalsModel {
    constructor(mutants) {
        const count = (status) => mutants.filter(_ => _.status === status).length;
        this.killed = count("Killed" /* Killed */);
        this.timeout = count("Timeout" /* Timeout */);
        this.survived = count("Survived" /* Survived */);
        this.noCoverage = count("NoCoverage" /* NoCoverage */);
        this.runtimeErrors = count("RuntimeError" /* RuntimeError */);
        this.compileErrors = count("CompileError" /* CompileError */);
        this.totalDetected = this.timeout + this.killed;
        this.totalUndetected = this.survived + this.noCoverage;
        this.totalCovered = this.totalDetected + this.survived;
        this.totalValid = this.totalUndetected + this.totalDetected;
        this.totalInvalid = this.runtimeErrors + this.compileErrors;
        this.totalMutants = this.totalValid + this.totalInvalid;
        this.mutationScore = this.totalValid > 0 ? this.totalDetected / this.totalValid * 100 : DEFAULT_SCORE;
        this.mutationScoreBasedOnCoveredCode = this.totalValid > 0 ? this.totalDetected / this.totalCovered * 100 || 0 : DEFAULT_SCORE;
    }
}
exports.TotalsModel = TotalsModel;
//# sourceMappingURL=TotalsModel.js.map