const fs = require('fs');
const path = require('path');
const {H264Stream} = require('../lib/codecs/h264.js');
const {groupNalsIntoFrames} = require('../lib/mp4/frame-utils.js');
const {CaptionStream} = require('../lib/m2ts/caption-stream.js');

const data = fs.readFileSync(path.join(__dirname, '..', 'test.264'));
const h264 = new H264Stream();
const captions = new CaptionStream();
const nals = [];

h264.on('data', (e) => {
  debugger;
  if (e.type === 0x06) {
    debugger;
    captions.push(e);
  }
  nals.push(e);
});

h264.push({type: 'video', data});
h264.flush();

const frames = groupNalsIntoFrames(nals);

console.log(JSON.stringify(frames, null, 2));
