![MVP.css](img/logo.png)

# MVP.css — Minimalist stylesheet for HTML elements

Out of the box CSS styling for HTML elements. No class names, no framework to learn.

`<link rel="stylesheet" href="https://unpkg.com/mvp.css">`

Live demo: https://andybrewer.github.io/mvp/

Unpkg: https://unpkg.com/mvp.css

NPM: https://www.npmjs.com/package/mvp.css

## Versions

### v1.6
* Added `[hidden]` styling to hide hidden elements
* Updated alternate table rows to use `--color-accent` for a more branded look
* Updated `<table>` to use `display: block` and removed `overflow` styling
* Updated `font` variable to `font-family`
* Updated `<pre>`, `<code>` and `<samp>` styling to have proper padding and recognize indented content
* Updated `line-height` to be a number instead of a percentage
* Updated multi-word dropdown menu titles to render on a single line

### v1.5
* Added browser default `:focus` styling back in for better tabbed navigation
* Updated `<a>` styling to use `display: inline-block` for better focus outlines on buttons
* Added `<label>` styling for `checkbox` and `radio` elements
* Added striped `<table>`

### v1.4
* Updated `<pre>` styling to use `pre-line` for better line breaks
* Added hover styling to `<details><summary>` tags

### v1.3
* Updated `<button>` `line-height` and `font` to match `<a><b>` button styles
* Added a `--font` variable
* Added dropdown menus

### v1.2
* Added `checkbox` and `radio` styling for `<input>` fields
* Added `disabled` and `readonly` styling

### v1.1
* Updated code blocks to use `<pre><code>` instead of `<samp>`
* Added light styling for `<select>` fields
* Added `<details>` and `<summary>` tags
* Added `prefers-color-scheme: dark` media query (commented out by default)
* Updated `<table>` styling

## Contributors
* [andybrewer](https://github.com/andybrewer)
* [nikolai-cc](https://github.com/nikolai-cc)
* [aembleton](https://github.com/aembleton)
* [simonw](https://github.com/simonw)
* [cfv1984](https://github.com/cfv1984)
* [irfaardy](https://github.com/irfaardy)
* [ruudud](https://github.com/ruudud)
* [edlinkiii](https://github.com/edlinkiii)
* [DiemenDesign](https://github.com/DiemenDesign)
* [thedamon](https://github.com/thedamon)
* [hongsw](https://github.com/hongsw)
* [ericwbailey](https://github.com/ericwbailey)
* [martin-v](https://github.com/martin-v)
* [GrosSacASac](https://github.com/GrosSacASac)