'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

exports.default = function (name) {
  var nameTokens = name.toUpperCase().split(/[\s+-]/);
  var tokens = [];

  var initials = '';

  // Remove all tokens after the first that starts with a non-letter character
  for (var i = 0; i < nameTokens.length; i++) {
    if (!LETTER_PATTERN.test(nameTokens[i])) {
      break;
    }

    tokens.push(nameTokens[i]);
  }

  if (tokens.length >= 1) {
    initials += tokens[0].substr(0, 1);
  }

  if (tokens.length >= 2) {
    // Find first non-initial
    var foundNonInitial = false;

    for (var _i = 1; _i < tokens.length; _i++) {
      if (!tokens[_i].match(/.\./)) {
        foundNonInitial = true;
        initials += tokens[_i].substr(0, 1);
        break;
      }
    }

    if (!foundNonInitial) {
      initials += tokens[1].substr(0, 1);
    }
  }

  return initials;
};

var LETTER_PATTERN = /^[a-z\u00C0-\u017F]/i;

// Return initials for a given name
module.exports = exports['default'];
//# sourceMappingURL=data:application/json;base64,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