import type { ConnectionOptions } from "./types";
export declare type NoAuth = void;
export interface TokenAuth {
    "auth_token": string;
}
export interface UserPass {
    user: string;
    pass?: string;
}
export interface NKeyAuth {
    nkey: string;
    sig: string;
}
export interface JwtAuth {
    jwt: string;
    nkey?: string;
    sig?: string;
}
declare type Auth = NoAuth | TokenAuth | UserPass | NKeyAuth | JwtAuth;
/**
 * Authenticator is an interface that returns credentials
 */
export interface Authenticator {
    (nonce?: string): Auth;
}
export declare function buildAuthenticator(opts: ConnectionOptions): Authenticator;
export declare function noAuthFn(): Authenticator;
/**
 * Returns an nkey authenticator that returns a public key
 * @param {Uint8Array | (() => Uint8Array)} seed
 * @return {NKeyAuth}
 */
export declare function nkeyAuthenticator(seed?: Uint8Array | (() => Uint8Array)): Authenticator;
/**
 * Returns a jwt authenticator. If a seed is provided, the public
 * key, and signature are calculated. Note if a signature is provided
 * the returned value should be a base64 encoded string.
 *
 * @return {JwtAuth}
 * @param ajwt
 * @param seed
 */
export declare function jwtAuthenticator(ajwt: string | (() => string), seed?: Uint8Array | (() => Uint8Array)): Authenticator;
/**
 * Returns a jwt authenticator configured from the specified creds file contents.
 * @param creds
 * @returns {JwtAuth}
 */
export declare function credsAuthenticator(creds: Uint8Array): Authenticator;
export {};
