"use strict";
/*
 * Copyright 2020-2021 The NATS Authors
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.JSONCodec = exports.StringCodec = void 0;
const error_1 = require("./error");
const encoders_1 = require("./encoders");
function StringCodec() {
    return {
        encode(d) {
            return encoders_1.TE.encode(d);
        },
        decode(a) {
            return encoders_1.TD.decode(a);
        },
    };
}
exports.StringCodec = StringCodec;
function JSONCodec() {
    return {
        encode(d) {
            try {
                if (d === undefined) {
                    // @ts-ignore: json will not handle undefined
                    d = null;
                }
                return encoders_1.TE.encode(JSON.stringify(d));
            }
            catch (err) {
                throw error_1.NatsError.errorForCode(error_1.ErrorCode.BadJson, err);
            }
        },
        decode(a) {
            try {
                return JSON.parse(encoders_1.TD.decode(a));
            }
            catch (err) {
                throw error_1.NatsError.errorForCode(error_1.ErrorCode.BadJson, err);
            }
        },
    };
}
exports.JSONCodec = JSONCodec;
//# sourceMappingURL=codec.js.map