import { ConsumerAPI, ConsumerOpts, JetStreamClient, JetStreamOptions, JetStreamPublishOptions, JetStreamPullSubscription, JetStreamSubscription, JsMsg, NatsConnection, PubAck, PullOptions } from "./types";
import { BaseApiClient } from "./jsbaseclient_api";
import { TypedSubscriptionOptions } from "./typedsub";
import { QueuedIterator } from "./queued_iterator";
import type { ConsumerOptsBuilder } from "./types";
export interface JetStreamSubscriptionInfoable {
    info: JetStreamSubscriptionInfo | null;
}
export declare class JetStreamClientImpl extends BaseApiClient implements JetStreamClient {
    api: ConsumerAPI;
    constructor(nc: NatsConnection, opts?: JetStreamOptions);
    publish(subj: string, data?: Uint8Array, opts?: Partial<JetStreamPublishOptions>): Promise<PubAck>;
    pull(stream: string, durable: string): Promise<JsMsg>;
    fetch(stream: string, durable: string, opts?: Partial<PullOptions>): QueuedIterator<JsMsg>;
    pullSubscribe(subject: string, opts?: ConsumerOptsBuilder | Partial<ConsumerOpts>): Promise<JetStreamPullSubscription>;
    subscribe(subject: string, opts?: ConsumerOptsBuilder | Partial<ConsumerOpts>): Promise<JetStreamSubscription>;
    _processOptions(subject: string, opts?: ConsumerOptsBuilder | Partial<ConsumerOpts>): Promise<JetStreamSubscriptionInfo>;
    _buildTypedSubscriptionOpts(jsi: JetStreamSubscriptionInfo): TypedSubscriptionOptions<JsMsg>;
    _maybeCreateConsumer(jsi: JetStreamSubscriptionInfo): Promise<void>;
}
interface JetStreamSubscriptionInfo extends ConsumerOpts {
    api: BaseApiClient;
    attached: boolean;
    deliver: string;
}
export {};
