"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConsumerAPIImpl = void 0;
const jsbaseclient_api_1 = require("./jsbaseclient_api");
const jslister_1 = require("./jslister");
const jsutil_1 = require("./jsutil");
class ConsumerAPIImpl extends jsbaseclient_api_1.BaseApiClient {
    constructor(nc, opts) {
        super(nc, opts);
    }
    add(stream, cfg) {
        return __awaiter(this, void 0, void 0, function* () {
            jsutil_1.validateStreamName(stream);
            const cr = {};
            cr.config = cfg;
            cr.stream_name = stream;
            if (cr.config.durable_name) {
                jsutil_1.validateDurableName(cr.config.durable_name);
            }
            const subj = cfg.durable_name
                ? `${this.prefix}.CONSUMER.DURABLE.CREATE.${stream}.${cfg.durable_name}`
                : `${this.prefix}.CONSUMER.CREATE.${stream}`;
            const r = yield this._request(subj, cr);
            return r;
        });
    }
    info(stream, name) {
        return __awaiter(this, void 0, void 0, function* () {
            jsutil_1.validateStreamName(stream);
            jsutil_1.validateDurableName(name);
            const r = yield this._request(`${this.prefix}.CONSUMER.INFO.${stream}.${name}`);
            return r;
        });
    }
    delete(stream, name) {
        return __awaiter(this, void 0, void 0, function* () {
            jsutil_1.validateStreamName(stream);
            jsutil_1.validateDurableName(name);
            const r = yield this._request(`${this.prefix}.CONSUMER.DELETE.${stream}.${name}`);
            const cr = r;
            return cr.success;
        });
    }
    list(stream) {
        jsutil_1.validateStreamName(stream);
        const filter = (v) => {
            const clr = v;
            return clr.consumers;
        };
        const subj = `${this.prefix}.CONSUMER.LIST.${stream}`;
        return new jslister_1.ListerImpl(subj, filter, this);
    }
}
exports.ConsumerAPIImpl = ConsumerAPIImpl;
//# sourceMappingURL=jsconsumer_api.js.map