import { ConsumerConfig, ConsumerOpts, ConsumerOptsBuilder, JsMsgCallback } from "./types";
export declare function consumerOpts(opts?: Partial<ConsumerConfig>): ConsumerOptsBuilder;
export declare class ConsumerOptsBuilderImpl implements ConsumerOptsBuilder {
    config: Partial<ConsumerConfig>;
    mack: boolean;
    stream: string;
    callbackFn?: JsMsgCallback;
    max?: number;
    constructor(opts?: Partial<ConsumerConfig>);
    getOpts(): ConsumerOpts;
    deliverTo(subject: string): void;
    manualAck(): void;
    durable(name: string): void;
    deliverAll(): void;
    deliverLast(): void;
    deliverNew(): void;
    startSequence(seq: number): void;
    startTime(time: Date): void;
    ackNone(): void;
    ackAll(): void;
    ackExplicit(): void;
    maxDeliver(max: number): void;
    maxAckPending(max: number): void;
    maxWaiting(max: number): void;
    maxMessages(max: number): void;
    callback(fn: JsMsgCallback): void;
}
export declare function isConsumerOptsBuilder(o: ConsumerOptsBuilder | Partial<ConsumerOpts>): o is ConsumerOptsBuilderImpl;
