"use strict";
/*
 * Copyright 2021 The NATS Authors
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.isConsumerOptsBuilder = exports.ConsumerOptsBuilderImpl = exports.consumerOpts = void 0;
const types_1 = require("./types");
const jsutil_1 = require("./jsutil");
function consumerOpts(opts) {
    return new ConsumerOptsBuilderImpl(opts);
}
exports.consumerOpts = consumerOpts;
// FIXME: some items here that may need to be addressed
// 503s?
// maxRetries()
// retryBackoff()
// ackWait(time)
// replayOriginal()
// rateLimit(bytesPerSec)
class ConsumerOptsBuilderImpl {
    constructor(opts) {
        this.stream = "";
        this.mack = false;
        this.config = jsutil_1.defaultConsumer("", opts || {});
        // not set
        this.config.ack_policy = types_1.AckPolicy.All;
    }
    getOpts() {
        const o = {};
        o.config = this.config;
        o.mack = this.mack;
        o.stream = this.stream;
        o.callbackFn = this.callbackFn;
        o.max = this.max;
        return o;
    }
    deliverTo(subject) {
        this.config.deliver_subject = subject;
    }
    manualAck() {
        this.mack = true;
    }
    durable(name) {
        jsutil_1.validateDurableName(name);
        this.config.durable_name = name;
    }
    deliverAll() {
        this.config.deliver_policy = types_1.DeliverPolicy.All;
    }
    deliverLast() {
        this.config.deliver_policy = types_1.DeliverPolicy.Last;
    }
    deliverNew() {
        this.config.deliver_policy = types_1.DeliverPolicy.New;
    }
    startSequence(seq) {
        if (seq <= 0) {
            throw new Error("sequence must be greater than 0");
        }
        this.config.deliver_policy = types_1.DeliverPolicy.StartSequence;
        this.config.opt_start_seq = seq;
    }
    startTime(time) {
        this.config.deliver_policy = types_1.DeliverPolicy.StartTime;
        this.config.opt_start_time = time.toISOString();
    }
    ackNone() {
        this.config.ack_policy = types_1.AckPolicy.None;
    }
    ackAll() {
        this.config.ack_policy = types_1.AckPolicy.All;
    }
    ackExplicit() {
        this.config.ack_policy = types_1.AckPolicy.Explicit;
    }
    maxDeliver(max) {
        this.config.max_deliver = max;
    }
    maxAckPending(max) {
        this.config.max_ack_pending = max;
    }
    maxWaiting(max) {
        this.config.max_waiting = max;
    }
    maxMessages(max) {
        this.max = max;
    }
    callback(fn) {
        this.callbackFn = fn;
    }
}
exports.ConsumerOptsBuilderImpl = ConsumerOptsBuilderImpl;
function isConsumerOptsBuilder(o) {
    return typeof o.getOpts === "function";
}
exports.isConsumerOptsBuilder = isConsumerOptsBuilder;
//# sourceMappingURL=jsconsumeropts.js.map