import { JetStreamOptions, Lister, NatsConnection, PurgeResponse, StoredMsg, StreamAPI, StreamConfig, StreamInfo, StreamInfoRequestOptions, StreamMsgResponse } from "./types";
import { BaseApiClient } from "./jsbaseclient_api";
import { MsgHdrs } from "./headers";
export declare class StreamAPIImpl extends BaseApiClient implements StreamAPI {
    constructor(nc: NatsConnection, opts?: JetStreamOptions);
    add(cfg?: Partial<StreamConfig>): Promise<StreamInfo>;
    delete(stream: string): Promise<boolean>;
    update(cfg?: StreamConfig): Promise<StreamInfo>;
    info(name: string, data?: StreamInfoRequestOptions): Promise<StreamInfo>;
    list(): Lister<StreamInfo>;
    purge(name: string): Promise<PurgeResponse>;
    deleteMessage(stream: string, seq: number, erase?: boolean): Promise<boolean>;
    getMessage(stream: string, seq: number): Promise<StoredMsg>;
    find(subject: string): Promise<string>;
}
export declare class StoredMsgImpl implements StoredMsg {
    subject: string;
    seq: number;
    data: Uint8Array;
    time: Date;
    header: MsgHdrs;
    constructor(smr: StreamMsgResponse);
    _parse(s: string): Uint8Array;
}
