import { Msg } from "./types";
import { MsgHdrs } from "./headers";
import type { Publisher } from "./protocol";
import type { MsgArg } from "./parser";
import { NatsError } from "./error";
export declare function isRequestError(msg: Msg): (NatsError | null);
export declare class MsgImpl implements Msg {
    _headers?: MsgHdrs;
    _msg: MsgArg;
    _rdata: Uint8Array;
    _reply: string;
    _subject: string;
    publisher: Publisher;
    constructor(msg: MsgArg, data: Uint8Array, publisher: Publisher);
    get subject(): string;
    get reply(): string;
    get sid(): number;
    get headers(): (MsgHdrs | undefined);
    get data(): Uint8Array;
    respond(data?: Uint8Array, opts?: {
        headers?: MsgHdrs;
        reply?: string;
    }): boolean;
}
