import type { Request } from "./request";
import type { Msg } from "./types";
import { NatsError } from "./error";
export declare class MuxSubscription {
    baseInbox: string;
    reqs: Map<string, Request>;
    constructor();
    size(): number;
    init(prefix?: string): string;
    add(r: Request): void;
    get(token: string): Request | undefined;
    cancel(r: Request): void;
    getToken(m: Msg): string | null;
    dispatcher(): (err: NatsError | null, m: Msg) => void;
    close(): void;
}
