import { ProtocolHandler } from "./protocol";
import { ConnectionOptions, JetStreamClient, JetStreamManager, JetStreamOptions, Msg, NatsConnection, PublishOptions, RequestOptions, ServerInfo, Stats, Status, Subscription, SubscriptionOptions } from "./types";
import { QueuedIterator } from "./queued_iterator";
export declare class NatsConnectionImpl implements NatsConnection {
    options: ConnectionOptions;
    protocol: ProtocolHandler;
    draining: boolean;
    listeners: QueuedIterator<Status>[];
    private constructor();
    static connect(opts?: ConnectionOptions): Promise<NatsConnection>;
    closed(): Promise<void | Error>;
    close(): Promise<void>;
    publish(subject: string, data?: Uint8Array, options?: PublishOptions): void;
    subscribe(subject: string, opts?: SubscriptionOptions): Subscription;
    request(subject: string, data?: Uint8Array, opts?: RequestOptions): Promise<Msg>;
    /***
       * Flushes to the server. Promise resolves when round-trip completes.
       * @returns {Promise<void>}
       */
    flush(): Promise<void>;
    drain(): Promise<void>;
    isClosed(): boolean;
    isDraining(): boolean;
    getServer(): string;
    status(): AsyncIterable<Status>;
    get info(): (ServerInfo | undefined);
    stats(): Stats;
    jetstreamManager(opts?: JetStreamOptions): Promise<JetStreamManager>;
    jetstream(opts?: JetStreamOptions): JetStreamClient;
}
