import { Deferred } from "./util";
export interface Dispatcher<T> {
    push(v: T): void;
}
export declare type DispatchedFn<T> = (data: T | null) => void;
export interface QueuedIterator<T> extends Dispatcher<T> {
    [Symbol.asyncIterator](): AsyncIterator<T>;
    stop(err?: Error): void;
    getProcessed(): number;
    getPending(): number;
    getReceived(): number;
}
export declare class QueuedIteratorImpl<T> implements QueuedIterator<T> {
    inflight: number;
    processed: number;
    received: number;
    protected noIterator: boolean;
    protected iterClosed: Deferred<void>;
    protected done: boolean;
    private signal;
    private yields;
    dispatchedFn?: DispatchedFn<T>;
    private err?;
    constructor();
    [Symbol.asyncIterator](): AsyncIterableIterator<T>;
    push(v: T): void;
    iterate(): AsyncIterableIterator<T>;
    stop(err?: Error): void;
    getProcessed(): number;
    getPending(): number;
    getReceived(): number;
}
