import { Server, ServerInfo, ServersChanged, URLParseFn } from "./types";
/**
 * @hidden
 */
export declare class ServerImpl implements Server {
    src: string;
    listen: string;
    hostname: string;
    port: number;
    didConnect: boolean;
    reconnects: number;
    lastConnect: number;
    gossiped: boolean;
    tlsName: string;
    constructor(u: string, gossiped?: boolean);
    toString(): string;
}
export interface ServersOptions {
    urlParseFn?: URLParseFn;
}
/**
 * @hidden
 */
export declare class Servers {
    private firstSelect;
    private readonly servers;
    private currentServer;
    private tlsName;
    constructor(randomize: boolean, listens?: string[]);
    updateTLSName(): void;
    getCurrentServer(): ServerImpl;
    addServer(u: string, implicit?: boolean): void;
    selectServer(): ServerImpl | undefined;
    removeCurrentServer(): void;
    removeServer(server: ServerImpl | undefined): void;
    length(): number;
    next(): ServerImpl | undefined;
    getServers(): ServerImpl[];
    update(info: ServerInfo): ServersChanged;
}
