import { DispatchedFn, QueuedIteratorImpl } from "./queued_iterator";
import type { Base, Msg, Subscription, SubscriptionOptions } from "./types";
import { Deferred, Timeout } from "./util";
import { NatsError } from "./error";
import type { ProtocolHandler } from "./protocol";
export declare class SubscriptionImpl extends QueuedIteratorImpl<Msg> implements Base, Subscription {
    sid: number;
    queue?: string;
    draining: boolean;
    max?: number;
    subject: string;
    drained?: Promise<void>;
    protocol: ProtocolHandler;
    timer?: Timeout<void>;
    info?: unknown;
    cleanupFn?: (sub: Subscription, info?: unknown) => void;
    closed: Deferred<void>;
    constructor(protocol: ProtocolHandler, subject: string, opts?: SubscriptionOptions);
    setDispatchedFn(cb: DispatchedFn<Msg>): void;
    callback(err: NatsError | null, msg: Msg): void;
    close(): void;
    unsubscribe(max?: number): void;
    cancelTimeout(): void;
    drain(): Promise<void>;
    isDraining(): boolean;
    isClosed(): boolean;
    getSubject(): string;
    getMax(): number | undefined;
    getID(): number;
}
