import type { SubscriptionImpl } from "./subscription";
import type { NatsError } from "./error";
export declare class Subscriptions {
    mux: SubscriptionImpl;
    subs: Map<number, SubscriptionImpl>;
    sidCounter: number;
    constructor();
    size(): number;
    add(s: SubscriptionImpl): SubscriptionImpl;
    setMux(s: SubscriptionImpl): SubscriptionImpl;
    getMux(): SubscriptionImpl | null;
    get(sid: number): (SubscriptionImpl | undefined);
    all(): (SubscriptionImpl)[];
    cancel(s: SubscriptionImpl): void;
    handleError(err?: NatsError): boolean;
    close(): void;
}
