import { ConnectionOptions, Server, URLParseFn } from "./types";
export declare function setTransportFactory(config: TransportFactory): void;
export declare function defaultPort(): number;
export declare function getUrlParseFn(): URLParseFn | undefined;
export declare function newTransport(): Transport;
export interface TransportFactory {
    factory?: () => Transport;
    defaultPort?: number;
    urlParseFn?: URLParseFn;
}
export interface Transport extends AsyncIterable<Uint8Array> {
    readonly isClosed: boolean;
    readonly lang: string;
    readonly version: string;
    readonly closeError?: Error;
    connect(server: Server, opts: ConnectionOptions): Promise<void>;
    [Symbol.asyncIterator](): AsyncIterableIterator<Uint8Array>;
    isEncrypted(): boolean;
    send(frame: Uint8Array): Promise<void>;
    close(err?: Error): Promise<void>;
    disconnect(): void;
    closed(): Promise<void | Error>;
}
