"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.newTransport = exports.getUrlParseFn = exports.defaultPort = exports.setTransportFactory = void 0;
/*
 * Copyright 2020-2021 The NATS Authors
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const types_1 = require("./types");
let transportConfig;
function setTransportFactory(config) {
    transportConfig = config;
}
exports.setTransportFactory = setTransportFactory;
function defaultPort() {
    return transportConfig !== undefined &&
        transportConfig.defaultPort !== undefined
        ? transportConfig.defaultPort
        : types_1.DEFAULT_PORT;
}
exports.defaultPort = defaultPort;
function getUrlParseFn() {
    return transportConfig !== undefined && transportConfig.urlParseFn
        ? transportConfig.urlParseFn
        : undefined;
}
exports.getUrlParseFn = getUrlParseFn;
function newTransport() {
    if (!transportConfig || typeof transportConfig.factory !== "function") {
        throw new Error("transport fn is not set");
    }
    return transportConfig.factory();
}
exports.newTransport = newTransport;
//# sourceMappingURL=transport.js.map