"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.builder = void 0;
const is_promise_1 = __importDefault(require("is-promise"));
const consts_1 = require("./consts");
const augmentResponse = (response) => {
    var _a;
    if (!response || response.statusCode !== consts_1.HTTP_STATUS_OK) {
        return response;
    }
    const metadata = { version: consts_1.METADATA_VERSION, builder_function: consts_1.BUILDER_FUNCTIONS_FLAG, ttl: (_a = response.ttl) !== null && _a !== void 0 ? _a : 0 };
    return Object.assign(Object.assign({}, response), { metadata });
};
const wrapHandler = (handler) => 
// eslint-disable-next-line promise/prefer-await-to-callbacks
(event, context, callback) => {
    if (event.httpMethod !== 'GET' && event.httpMethod !== 'HEAD') {
        return Promise.resolve({
            body: 'Method Not Allowed',
            statusCode: consts_1.HTTP_STATUS_METHOD_NOT_ALLOWED,
        });
    }
    // Removing query string parameters from the builder function.
    const modifiedEvent = Object.assign(Object.assign({}, event), { multiValueQueryStringParameters: {}, queryStringParameters: {} });
    // eslint-disable-next-line promise/prefer-await-to-callbacks
    const wrappedCallback = (error, response) => callback === null || callback === void 0 ? void 0 : callback(error, augmentResponse(response));
    const execution = handler(modifiedEvent, context, wrappedCallback);
    if ((0, is_promise_1.default)(execution)) {
        // eslint-disable-next-line promise/prefer-await-to-then
        return execution.then(augmentResponse);
    }
    return execution;
};
exports.builder = wrapHandler;
