import { Context as HandlerContext, Context } from '../v1/context';
import { Event as HandlerEvent } from '../v1/event';
import { BaseHandler, HandlerCallback } from '../v1/handler';
import { Response } from '../v1/response';
import { NetlifySecrets } from './secrets_helper';
export { getSecrets } from './secrets_helper';
export { getNetlifyGraphToken, GraphTokenResponse, HasHeaders } from './graph_token';
export interface ContextWithSecrets extends Context {
    secrets: NetlifySecrets;
}
export declare type HandlerWithSecrets = BaseHandler<Response, ContextWithSecrets>;
export declare const withSecrets: (handler: BaseHandler<Response, ContextWithSecrets>) => (event: HandlerEvent, context: HandlerContext, callback: HandlerCallback<Response>) => Promise<void | Response>;
