"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.withSecrets = exports.getNetlifyGraphToken = exports.getSecrets = void 0;
const secrets_helper_1 = require("./secrets_helper");
// Fine-grained control during the preview, less necessary with a more proactive OneGraph solution
var secrets_helper_2 = require("./secrets_helper");
Object.defineProperty(exports, "getSecrets", { enumerable: true, get: function () { return secrets_helper_2.getSecrets; } });
var graph_token_1 = require("./graph_token");
Object.defineProperty(exports, "getNetlifyGraphToken", { enumerable: true, get: function () { return graph_token_1.getNetlifyGraphToken; } });
// The common usage of this module
const withSecrets = (handler) => (event, context, 
// eslint-disable-next-line promise/prefer-await-to-callbacks
callback) => __awaiter(void 0, void 0, void 0, function* () {
    const secrets = yield (0, secrets_helper_1.getSecrets)(event);
    return handler(event, Object.assign(Object.assign({}, context), { secrets }), callback);
});
exports.withSecrets = withSecrets;
