"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.graphRequest = void 0;
const buffer_1 = require("buffer");
const https_1 = require("https");
const process_1 = require("process");
const siteId = process_1.env.SITE_ID;
const GRAPH_HOST = 'graph.netlify.com';
const graphRequest = function (secretToken, requestBody) {
    return new Promise((resolve, reject) => {
        const port = 443;
        const options = {
            host: GRAPH_HOST,
            path: `/graphql?app_id=${siteId}`,
            port,
            method: 'POST',
            headers: {
                Authorization: `Bearer ${secretToken}`,
                'Content-Type': 'application/json',
                Accept: 'application/json',
                'Content-Length': requestBody ? buffer_1.Buffer.byteLength(requestBody) : 0,
            },
        };
        const req = (0, https_1.request)(options, (res) => {
            if (res.statusCode !== 200) {
                return reject(new Error(String(res.statusCode)));
            }
            const body = [];
            res.on('data', (chunk) => {
                body.push(chunk);
            });
            res.on('end', () => {
                const data = buffer_1.Buffer.concat(body).toString();
                try {
                    resolve(data);
                }
                catch (error) {
                    reject(error);
                }
            });
        });
        req.on('error', (error) => {
            reject(error);
        });
        req.write(requestBody);
        req.end();
    });
};
exports.graphRequest = graphRequest;
