"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSecrets = void 0;
const graph_request_1 = require("./graph_request");
const graph_token_1 = require("./graph_token");
const services = {
    gitHub: null,
    spotify: null,
    salesforce: null,
    stripe: null,
};
const camelize = function (text) {
    const safe = text.replace(/[-_\s.]+(.)?/g, (_, sub) => (sub ? sub.toUpperCase() : ''));
    return safe.slice(0, 1).toLowerCase() + safe.slice(1);
};
// The services will be camelized versions of the OneGraph service enums
// unless overridden by the serviceNormalizeOverrides object
const serviceNormalizeOverrides = {
    // Keys are the OneGraph service enums, values are the desired `secret.<service>` names
    GITHUB: 'gitHub',
};
const formatSecrets = (result) => {
    var _a, _b, _c;
    const responseServices = (_c = (_b = (_a = result === null || result === void 0 ? void 0 : result.data) === null || _a === void 0 ? void 0 : _a.me) === null || _b === void 0 ? void 0 : _b.serviceMetadata) === null || _c === void 0 ? void 0 : _c.loggedInServices;
    if (!responseServices) {
        return {};
    }
    const newSecrets = responseServices.reduce((acc, service) => {
        const normalized = serviceNormalizeOverrides[service.service] || camelize(service.friendlyServiceName);
        return Object.assign(Object.assign({}, acc), { [normalized]: service });
    }, {});
    return newSecrets;
};
const logErrors = function (errors) {
    for (const error of errors) {
        let errorMessage;
        switch (error.type) {
            case 'missing-event-in-function':
                errorMessage =
                    'You must provide an event or request to `getSecrets` when used in functions and on-demand builders.';
                break;
            case 'provided-event-in-build':
                errorMessage = 'You must not pass arguments to `getSecrets` when used in builds.';
                break;
            default: {
                // eslint-disable-next-line @typescript-eslint/no-unused-vars
                const exhaustiveCheck = error.type;
                errorMessage = error.type;
                break;
            }
        }
        const message = errorMessage;
        console.error(message);
    }
};
// Note: We may want to have configurable "sets" of secrets,
// e.g. "dev" and "prod"
const getSecrets = (event) => __awaiter(void 0, void 0, void 0, function* () {
    const graphTokenResponse = (0, graph_token_1.getNetlifyGraphToken)(event, true);
    const graphToken = graphTokenResponse.token;
    if (!graphToken) {
        if (graphTokenResponse.errors) {
            logErrors(graphTokenResponse.errors);
        }
        return {};
    }
    // We select for more than we typeically need here
    // in order to allow for some metaprogramming for
    // consumers downstream. Also, the data is typically
    // static and shouldn't add any measurable overhead.
    const doc = `query FindLoggedInServicesQuery {
    me {
      serviceMetadata {
        loggedInServices {
          friendlyServiceName
          service
          isLoggedIn
          bearerToken
          grantedScopes {
            scope
            scopeInfo {
              category
              scope
              display
              isDefault
              isRequired
              description
              title
            }
          }
        }
      }
    }
  }`;
    const body = JSON.stringify({ query: doc });
    // eslint-disable-next-line node/no-unsupported-features/node-builtins
    const resultBody = yield (0, graph_request_1.graphRequest)(graphToken, new TextEncoder().encode(body));
    const result = JSON.parse(resultBody);
    const newSecrets = formatSecrets(result);
    return newSecrets;
});
exports.getSecrets = getSecrets;
