"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getV2Handler = void 0;
const undici_1 = require("undici");
const context_1 = require("./context");
const cookie_store_1 = require("./cookie_store");
const headers_1 = require("./headers");
const getV2Handler = (func, event) => __awaiter(void 0, void 0, void 0, function* () {
    const headers = (0, headers_1.fromEventHeaders)(event.headers);
    const req = new undici_1.Request(event.rawUrl, {
        body: event.body,
        headers,
        method: event.httpMethod,
    });
    const cookies = new cookie_store_1.CookieStore(req);
    const context = (0, context_1.getContext)({ cookies });
    const res = yield func.default(req, context);
    cookies.apply(res);
    const responseHeaders = (0, headers_1.toObject)(res.headers);
    const body = yield res.text();
    return {
        body,
        headers: responseHeaders,
        statusCode: res.status,
    };
});
exports.getV2Handler = getV2Handler;
