"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getHandler = void 0;
const api_1 = require("../api");
const isV1API = (func) => typeof func.handler === 'function';
const getHandler = (func) => (event, lambdaContext) => {
    if (isV1API(func)) {
        return func.handler(event, lambdaContext);
    }
    return (0, api_1.getV2Handler)(func, event);
};
exports.getHandler = getHandler;
