"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getContext = void 0;
const undici_1 = require("undici");
const json = (input) => {
    const data = JSON.stringify(input);
    return new undici_1.Response(data, {
        headers: {
            'content-type': 'application/json',
        },
    });
};
const getContext = ({ cookies }) => {
    const context = {
        cookies: cookies.getPublicInterface(),
        json,
    };
    return context;
};
exports.getContext = getContext;
