"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CookieStore = void 0;
/* eslint-disable no-use-before-define */
const cookie_1 = require("../vendor/std/http/cookie");
class CookieStore {
    constructor(request) {
        this.ops = [];
        this.request = request;
    }
    apply(response) {
        this.ops.forEach((op) => {
            switch (op.type) {
                case 'delete':
                    (0, cookie_1.deleteCookie)(response.headers, op.options.name, {
                        domain: op.options.domain,
                        path: op.options.path,
                    });
                    break;
                case 'set':
                    (0, cookie_1.setCookie)(response.headers, op.cookie);
                    break;
                default:
            }
        });
    }
    delete(input) {
        const defaultOptions = {
            path: '/',
        };
        const options = typeof input === 'string' ? { name: input } : input;
        this.ops.push({
            options: Object.assign(Object.assign({}, defaultOptions), options),
            type: 'delete',
        });
    }
    get(name) {
        return (0, cookie_1.getCookies)(this.request.headers)[name];
    }
    getPublicInterface() {
        return {
            delete: this.delete.bind(this),
            get: this.get.bind(this),
            set: this.set.bind(this),
        };
    }
    set(cookie) {
        this.ops.push({ cookie, type: 'set' });
    }
}
exports.CookieStore = CookieStore;
/* eslint-enable no-use-before-define */
