"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.toObject = exports.fromEventHeaders = void 0;
const undici_1 = require("undici");
const fromEventHeaders = (eventHeaders) => {
    const headers = new undici_1.Headers();
    Object.entries(eventHeaders).forEach(([name, value]) => {
        if (value !== undefined) {
            headers.set(name, value);
        }
    });
    return headers;
};
exports.fromEventHeaders = fromEventHeaders;
const toObject = (headers) => {
    const headersObj = {};
    for (const [name, value] of headers.entries()) {
        headersObj[name] = value;
    }
    return headersObj;
};
exports.toObject = toObject;
