import { Rule } from "./tokenizer.js";
declare type DateTimeFormatPartTypes = "day" | "dayPeriod" | "hour" | "literal" | "minute" | "month" | "second" | "timeZoneName" | "year" | "fractionalSecond";
interface DateTimeFormatPart {
    type: DateTimeFormatPartTypes;
    value: string;
}
declare type TimeZone = "UTC";
interface Options {
    timeZone?: TimeZone;
}
export declare class DateTimeFormatter {
    #private;
    constructor(formatString: string, rules?: Rule[]);
    format(date: Date, options?: Options): string;
    parseToParts(string: string): DateTimeFormatPart[];
    /** sort & filter dateTimeFormatPart */
    sortDateTimeFormatPart(parts: DateTimeFormatPart[]): DateTimeFormatPart[];
    partsToDate(parts: DateTimeFormatPart[]): Date;
    parse(string: string): Date;
}
export {};
