export declare type Token = {
    type: string;
    value: string | number;
    index: number;
    [key: string]: unknown;
};
export interface ReceiverResult {
    [name: string]: string | number | unknown;
}
export declare type CallbackResult = {
    type: string;
    value: string | number;
    [key: string]: unknown;
};
declare type CallbackFunction = (value: unknown) => CallbackResult;
export declare type TestResult = {
    value: unknown;
    length: number;
} | undefined;
export declare type TestFunction = (string: string) => TestResult | undefined;
export interface Rule {
    test: TestFunction;
    fn: CallbackFunction;
}
export declare class Tokenizer {
    rules: Rule[];
    constructor(rules?: Rule[]);
    addRule(test: TestFunction, fn: CallbackFunction): Tokenizer;
    tokenize(string: string, receiver?: (token: Token) => ReceiverResult): ReceiverResult[];
}
export {};
