import * as dntShim from "../_dnt.shims.js";
export interface Cookie {
    /** Name of the cookie. */
    name: string;
    /** Value of the cookie. */
    value: string;
    /** Expiration date of the cookie. */
    expires?: Date;
    /** Max-Age of the Cookie. Max-Age must be an integer superior or equal to 0. */
    maxAge?: number;
    /** Specifies those hosts to which the cookie will be sent. */
    domain?: string;
    /** Indicates a URL path that must exist in the request. */
    path?: string;
    /** Indicates if the cookie is made using SSL & HTTPS. */
    secure?: boolean;
    /** Indicates that cookie is not accessible via JavaScript. */
    httpOnly?: boolean;
    /**
     * Allows servers to assert that a cookie ought not to
     * be sent along with cross-site requests.
     */
    sameSite?: "Strict" | "Lax" | "None";
    /** Additional key value pairs with the form "key=value" */
    unparsed?: string[];
}
/**
 * Parse cookies of a header
 * @param {Headers} headers The headers instance to get cookies from
 * @return {Object} Object with cookie names as keys
 */
export declare function getCookies(headers: dntShim.Headers): Record<string, string>;
/**
 * Set the cookie header properly in the headers
 * @param {Headers} headers The headers instance to set the cookie to
 * @param {Object} cookie Cookie to set
 */
export declare function setCookie(headers: dntShim.Headers, cookie: Cookie): void;
/**
 * Set the cookie header with empty value in the headers to delete it
 * @param {Headers} headers The headers instance to delete the cookie from
 * @param {string} name Name of cookie
 * @param {Object} attributes Additional cookie attributes
 */
export declare function deleteCookie(headers: dntShim.Headers, name: string, attributes?: {
    path?: string;
    domain?: string;
}): void;
