/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
import { arrForEach } from "../array/forEach";
import { ArrProto, CALL, SLICE } from "../internal/constants";
import { objCopyProps, objDeepCopy } from "../object/copy";
/**
 * @internal
 * @ignore
 */
function _doExtend(target, theArgs) {
    arrForEach(theArgs, function (theArg) {
        objCopyProps(target, theArg);
    });
    return target;
}
/**
 * Create a new object by merging the passed arguments, this is effectively the same as calling `objExtend({}, ...theArgs)` where
 * all of the arguments are added to a new object that is returned.
 * @group Object
 * @param target - The original object to be extended.
 * @param objN - The optional number of arguments to be copied
 * @returns - A new object or the original
 */
export function deepExtend(target, obj1, obj2, obj3, obj4, obj5, obj6) {
    return _doExtend(objDeepCopy(target) || {}, ArrProto[SLICE][CALL](arguments));
}
/**
 * Extend the target object by merging the passed arguments into it
 * @group Object
 * @param target - The object to be extended or overwritten
 * @param objN - The optional number of arguments to be copied
 * @returns - A new object or the original
 */
export function objExtend(target, obj1, obj2, obj3, obj4, obj5, obj6) {
    return _doExtend(target || {}, ArrProto[SLICE][CALL](arguments));
}
//# sourceMappingURL=extend.js.map