/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
/**
 * Call the specified function with zero or more individual arguments, the call will be wrapped in a try / catch
 * block and the result returned wrapped in an {@link ISafeReturn} instance. If the function call throws an
 * exception the {@link ISafeReturn.e error} property will contain the exception otherwise the {@link ISafeReturn.v value}
 * property will contain the value returned from the function.
 * @since 0.10.5
 * @group Safe
 * @param func - The function to call
 * @param argArray - An array of the arguments to pass to the function
 * @returns The return value of the function or undefined if an exception is thrown
 * @example
 * ```ts
 * let result = safe((value: string) => {
 *    return JSON.parse(value);
 * }, ["{ invalid: json value"]);
 *
 * // result.e instanceof SyntaxError
 *
 * let result2 = safe((value: string) => {
 *   return JSON.parse(value);
 * }, ["{ valid: json value"]);
 *
 * // result2.v === { valid: "json value" }
 */
export function safe(func, argArray) {
    try {
        return {
            v: func.apply(this, argArray)
        };
    }
    catch (e) {
        return { e: e };
    }
}
//# sourceMappingURL=safe.js.map