/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
/**
 * Throw an error exception with the specified optional message
 * @group Error
 * @param message
 */
export function throwError(message) {
    throw new Error(message);
}
/**
 * Throw a type error with the specified optional message
 * @group Error
 * @param message
 */
export function throwTypeError(message) {
    throw new TypeError(message);
}
/**
 * Throw a RangeError with the specified optional message
 * @group Error
 * @param message
 */
export function throwRangeError(message) {
    throw new RangeError(message);
}
//# sourceMappingURL=throw.js.map