/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
import { safe } from "../helpers/safe";
import { UNDEFINED } from "./constants";
var GLOBAL_CONFIG_KEY = "__tsUtils$gblCfg";
var _globalCfg;
/**
 * @internal
 * @ignore
 * Helper to get the current global value
 * @returns
 */
export function _getGlobalValue() {
    var result;
    if (typeof globalThis !== UNDEFINED) {
        result = globalThis;
    }
    if (!result && typeof self !== UNDEFINED) {
        result = self;
    }
    if (!result && typeof window !== UNDEFINED) {
        result = window;
    }
    if (!result && typeof global !== UNDEFINED) {
        result = global;
    }
    return result;
}
/**
 * @internal
 * @ignore
 * Gets/Sets the named value from the global config store, this is used to share configuration across
 * multiple modules. Primarily used for poly symbol and test hooks.
 * @returns The globally registered value.
 */
/*#__NO_SIDE_EFFECTS__*/
export function _getGlobalConfig() {
    if (!_globalCfg) {
        var gbl = safe(_getGlobalValue).v || {};
        _globalCfg = gbl[GLOBAL_CONFIG_KEY] = gbl[GLOBAL_CONFIG_KEY] || {};
    }
    return _globalCfg;
}
//# sourceMappingURL=global.js.map