/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
import { NULL_VALUE } from "../internal/constants";
import { objDefineProp } from "../object/define";
var REF = "ref";
var UNREF = "un" + REF;
var HAS_REF = "hasRef";
var ENABLED = "enabled";
/**
 * @ignore
 * @internal
 * Internal function to create and manage an ITimerHandler implementation, the object returned from this function
 * it directly used / returned by the pulic functions used to create timers (idle, interval and timeout)
 * @param startTimer - Should the timer be started as part of creating the handler
 * @param refreshFn - The function used to create/start or refresh the timer
 * @param cancelFn - The function used to cancel the timer.
 * @returns The new ITimerHandler instance
 */
export function _createTimerHandler(startTimer, refreshFn, cancelFn) {
    var _a;
    var ref = true;
    var timerId = startTimer ? refreshFn(NULL_VALUE) : NULL_VALUE;
    var theTimerHandler;
    var _unref = function () {
        ref = false;
        timerId && timerId[UNREF] && timerId[UNREF]();
        return theTimerHandler;
    };
    var _ref = function () {
        ref = true;
        timerId && timerId[REF] && timerId[REF]();
        return theTimerHandler;
    };
    var _hasRef = function () {
        if (timerId && timerId[HAS_REF]) {
            return timerId[HAS_REF]();
        }
        return ref;
    };
    var _refresh = function () {
        timerId = refreshFn(timerId);
        if (!ref) {
            _unref();
        }
        return theTimerHandler;
    };
    var _cancel = function () {
        timerId && cancelFn(timerId);
        timerId = NULL_VALUE;
    };
    var _setEnabled = function (value) {
        !value && timerId && _cancel();
        value && !timerId && _refresh();
    };
    theTimerHandler = (_a = {
            cancel: _cancel,
            refresh: _refresh
        },
        _a[HAS_REF] = _hasRef,
        _a[REF] = _ref,
        _a[UNREF] = _unref,
        _a[ENABLED] = false,
        _a);
    objDefineProp(theTimerHandler, ENABLED, {
        get: function () { return !!timerId; },
        set: _setEnabled
    });
    return {
        h: theTimerHandler,
        dn: function () {
            timerId = NULL_VALUE;
        }
    };
}
//# sourceMappingURL=handler.js.map