/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
import { objForEachKey } from "../object/for_each_key";
/**
 * @internal
 * @ignore
 * Internal Helper function to create a key and value mapped representation of the values
 * @param values - The source values
 * @param keyType - Identifies the value to populate against the key
 * @param valueType - Identifies the value to populate against the value
 * @param completeFn - The function to call to complete the map (used to freeze the instance)
 * @returns
 */
/*#__NO_SIDE_EFFECTS__*/
export function _createKeyValueMap(values, keyType, valueType, completeFn) {
    let theMap = {};
    objForEachKey(values, (key, value) => {
        theMap[key] = keyType ? value : key;
        theMap[value] = valueType ? value : key;
    });
    return completeFn(theMap);
}
//# sourceMappingURL=map.js.map