/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
import { StrProto } from "../internal/constants";
import { _unwrapFunction } from "../internal/unwrapFunction";
/**
 * The strUpper() method returns the calling string value converted to uppercase.
 * (the value will be converted to a string if it isn't one).
 * @since 0.9.0
 * @group String
 * @group Conversion
 * @param value - The string value to be converted to uppercase.
 * @return A new string representing the calling string converted to upper case.
 * @throws TypeError - When called on null or undefined.
 * @example
 * ```ts
 * strUpper("Hello");       // HELLO
 * strUpper("darkness");    // DARKNESS
 *
 * strUpper(null);          // Throws TypeError
 * strUpper(undefined);     // Throws TypeError
 * ```
 */
export const strUpper = ( /*#__PURE__*/_unwrapFunction("toUpperCase", StrProto));
/**
 * The strLower() method returns the value of the string converted to lower case.
 * strLower() does not affect the value of the string str itself.
 * @since 0.9.0
 * @group String
 * @group Conversion
 * @return A new string representing the calling string converted to lower case.
 * @throws TypeError - When called on null or undefined.
 * @example
 * ```ts
 * strLower("Hello");       // hello
 * strLower("darkness");    // darkness
 *
 * strLower(null);          // Throws TypeError
 * strLower(undefined);     // Throws TypeError
 * ```
 */
export const strLower = ( /*#__PURE__*/_unwrapFunction("toLowerCase", StrProto));
//# sourceMappingURL=upper_lower.js.map