/*
 * @nevware21/ts-utils
 * https://github.com/nevware21/ts-utils
 *
 * Copyright (c) 2022 Nevware21
 * Licensed under the MIT license.
 */
import { NULL_VALUE } from "../internal/constants";
import { objDefineProp } from "../object/define";
const REF = "ref";
const UNREF = "un" + REF;
const HAS_REF = "hasRef";
const ENABLED = "enabled";
/**
 * @ignore
 * @internal
 * Internal function to create and manage an ITimerHandler implementation, the object returned from this function
 * it directly used / returned by the pulic functions used to create timers (idle, interval and timeout)
 * @param startTimer - Should the timer be started as part of creating the handler
 * @param refreshFn - The function used to create/start or refresh the timer
 * @param cancelFn - The function used to cancel the timer.
 * @returns The new ITimerHandler instance
 */
export function _createTimerHandler(startTimer, refreshFn, cancelFn) {
    let ref = true;
    let timerId = startTimer ? refreshFn(NULL_VALUE) : NULL_VALUE;
    let theTimerHandler;
    const _unref = () => {
        ref = false;
        timerId && timerId[UNREF] && timerId[UNREF]();
        return theTimerHandler;
    };
    const _ref = () => {
        ref = true;
        timerId && timerId[REF] && timerId[REF]();
        return theTimerHandler;
    };
    const _hasRef = () => {
        if (timerId && timerId[HAS_REF]) {
            return timerId[HAS_REF]();
        }
        return ref;
    };
    const _refresh = () => {
        timerId = refreshFn(timerId);
        if (!ref) {
            _unref();
        }
        return theTimerHandler;
    };
    const _cancel = () => {
        timerId && cancelFn(timerId);
        timerId = NULL_VALUE;
    };
    const _setEnabled = (value) => {
        !value && timerId && _cancel();
        value && !timerId && _refresh();
    };
    theTimerHandler = {
        cancel: _cancel,
        refresh: _refresh,
        [HAS_REF]: _hasRef,
        [REF]: _ref,
        [UNREF]: _unref,
        [ENABLED]: false
    };
    objDefineProp(theTimerHandler, ENABLED, {
        get: () => !!timerId,
        set: _setEnabled
    });
    return {
        h: theTimerHandler,
        dn: () => {
            timerId = NULL_VALUE;
        }
    };
}
//# sourceMappingURL=handler.js.map