/*! https://github.com/nevware21/ts-utils v0.10.5 */
/*
 * Copyright (c) NevWare21 and contributors. All rights reserved.
 * Licensed under the MIT license.
 */
this.nevware21 = this.nevware21 || {};
this.nevware21["ts-utils"] = (function (exports) {
    'use strict';

    var UNDEF_VALUE = undefined;
    var NULL_VALUE = null;
    var EMPTY = "";
    var BOOLEAN = "boolean";
    var FUNCTION = "function";
    var NUMBER = "number";
    var OBJECT = "object";
    var PROTOTYPE = "prototype";
    var __PROTO__ = "__proto__";
    var STRING = "string";
    var UNDEFINED = "undefined";
    var CONSTRUCTOR = "constructor";
    var SYMBOL = "Symbol";
    var POLYFILL_TAG = "_polyfill";
    var INDEX_OF = "indexOf";
    var LAST_INDEX_OF = "lastIndexOf";
    var LENGTH = "length";
    var DONE = "done";
    var VALUE = "value";
    var NAME = "name";
    var SLICE = "slice";
    var CALL = "call";
    var TO_STRING = "toString";
    var ObjClass = Object;
    var ObjProto = ObjClass[PROTOTYPE];
    var StrCls = String;
    var StrProto = StrCls[PROTOTYPE];
    var MathCls = Math;
    var ArrCls = Array;
    var ArrProto = ArrCls[PROTOTYPE];

    function safe(func, argArray) {
        try {
            return {
                v: func.apply(this, argArray)
            };
        }
        catch (e) {
            return { e: e };
        }
    }

    function safeGet(cb, defValue) {
        var result = safe(cb);
        return result.e ? defValue : result.v;
    }

    var PRIMITIVE_TYPES = [STRING, NUMBER, BOOLEAN, UNDEFINED, "symbol", "bigint"];
    /*#__NO_SIDE_EFFECTS__*/
    function _createIs(theType) {
        return function (value) {
            return typeof value === theType;
        };
    }
    /*#__NO_SIDE_EFFECTS__*/
    function _createObjIs(theName) {
        var theType = "[object " + theName + "]";
        return function (value) {
            return !!(value && objToString(value) === theType);
        };
    }
    /*#__NO_SIDE_EFFECTS__*/
    function objToString(value) {
        return ObjProto.toString.call(value);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function isTypeof(value, theType) {
        return typeof value === theType;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function isUndefined(value) {
        return typeof value === UNDEFINED || value === UNDEFINED;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function isStrictUndefined(arg) {
        return !isDefined(arg);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function isNullOrUndefined(value) {
        return value === NULL_VALUE || isUndefined(value);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function isStrictNullOrUndefined(value) {
        return value === NULL_VALUE || !isDefined(value);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function isDefined(arg) {
        return !!arg || arg !== UNDEF_VALUE;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function isPrimitive(value) {
        return value === NULL_VALUE || isPrimitiveType(typeof value);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function isPrimitiveType(theType) {
        return theType !== OBJECT && PRIMITIVE_TYPES.indexOf(theType) !== -1;
    }
    var isString = ( /*#__PURE__*/_createIs(STRING));
    var isFunction = ( /*#__PURE__*/_createIs(FUNCTION));
    /*#__NO_SIDE_EFFECTS__*/
    function isObject(value) {
        if (!value && isNullOrUndefined(value)) {
            return false;
        }
        return !!value && typeof value === OBJECT;
    }
    var isArray = ArrCls.isArray;
    var isDate = ( /*#__PURE__*/_createObjIs("Date"));
    var isNumber = ( /*#__PURE__*/_createIs(NUMBER));
    var isBoolean = ( /*#__PURE__*/_createIs(BOOLEAN));
    var isRegExp = ( /*#__PURE__*/_createObjIs("RegExp"));
    var isFile = ( /*#__PURE__*/_createObjIs("File"));
    var isFormData = ( /*#__PURE__*/_createObjIs("FormData"));
    var isBlob = ( /*#__PURE__*/_createObjIs("Blob"));
    var isArrayBuffer = ( /*#__PURE__*/_createObjIs("ArrayBuffer"));
    var isError = ( /*#__PURE__*/_createObjIs("Error"));
    /*#__NO_SIDE_EFFECTS__*/
    function isPromiseLike(value) {
        return !!(value && value.then && isFunction(value.then));
    }
    var isThenable = isPromiseLike;
    /*#__NO_SIDE_EFFECTS__*/
    function isPromise(value) {
        return !!(value && value.then && value.catch && isFunction(value.then) && isFunction(value.catch));
    }
    /*#__NO_SIDE_EFFECTS__*/
    function isNotTruthy(value) {
        return !value || !isTruthy(value);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function isTruthy(value) {
        return !(!value || safeGet(function () { return !(value && (0 + value)); }, !value));
    }

    var objGetOwnPropertyDescriptor = ObjClass.getOwnPropertyDescriptor;

    /*#__NO_SIDE_EFFECTS__*/
    function objHasOwnProperty(obj, prop) {
        return !!obj && ObjProto.hasOwnProperty[CALL](obj, prop);
    }

    var objHasOwn = ObjClass["hasOwn"] || polyObjHasOwn;
    /*#__NO_SIDE_EFFECTS__*/
    function polyObjHasOwn(obj, prop) {
        return objHasOwnProperty(obj, prop) || !!objGetOwnPropertyDescriptor(obj, prop);
    }

    function objForEachKey(theObject, callbackfn, thisArg) {
        if (theObject && isObject(theObject)) {
            for (var prop in theObject) {
                if (objHasOwn(theObject, prop)) {
                    if (callbackfn[CALL](thisArg || theObject, prop, theObject[prop]) === -1) {
                        break;
                    }
                }
            }
        }
    }

    /*#__NO_SIDE_EFFECTS__*/
    function _createKeyValueMap(values, keyType, valueType, completeFn) {
        var theMap = {};
        objForEachKey(values, function (key, value) {
            theMap[key] = keyType ? value : key;
            theMap[value] = valueType ? value : key;
        });
        return completeFn(theMap);
    }

    function throwError(message) {
        throw new Error(message);
    }
    function throwTypeError(message) {
        throw new TypeError(message);
    }
    function throwRangeError(message) {
        throw new RangeError(message);
    }

    /*#__NO_SIDE_EFFECTS__*/
    function polyObjKeys(obj) {
        if (!isObject(obj) || obj === NULL_VALUE) {
            throwTypeError("polyObjKeys called on non-object");
        }
        var result = [];
        for (var prop in obj) {
            if (objHasOwn(obj, prop)) {
                result.push(prop);
            }
        }
        return result;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function polyObjEntries(value) {
        var result = [];
        objForEachKey(value, function (key, value) {
            result.push([key, value]);
        });
        return result;
    }

    var _objFreeze = ObjClass["freeze"];
    function _doNothing(value) {
        return value;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function _getProto(value) {
        return value[__PROTO__] || NULL_VALUE;
    }
    var objAssign = ObjClass["assign"];
    var objKeys = ObjClass.keys;
    function objDeepFreeze(value) {
        if (_objFreeze) {
            objForEachKey(value, function (key, value) {
                if (isArray(value) || isObject(value)) {
                    _objFreeze(value);
                }
            });
        }
        return objFreeze(value);
    }
    var objFreeze = _objFreeze || _doNothing;
    var objSeal = ObjClass["seal"] || _doNothing;
    var objGetPrototypeOf = ObjClass["getPrototypeOf"] || _getProto;
    var objEntries = ObjClass.entries || polyObjEntries;

    /*#__NO_SIDE_EFFECTS__*/
    function createEnum(values) {
        return _createKeyValueMap(values, 1 , 0 , objDeepFreeze);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function createEnumKeyMap(values) {
        return _createKeyValueMap(values, 0 , 0 , objDeepFreeze);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function createEnumValueMap(values) {
        return _createKeyValueMap(values, 1 , 1 , objDeepFreeze);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function createSimpleMap(values) {
        var mapClass = {};
        objForEachKey(values, function (key, value) {
            mapClass[key] = value[1];
            mapClass[value[0]] = value[1];
        });
        return objDeepFreeze(mapClass);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function createTypeMap(values) {
        return createSimpleMap(values);
    }

    var _wellKnownSymbolMap = /*#__PURE__*/ createEnumKeyMap({
        asyncIterator: 0 ,
        hasInstance: 1 ,
        isConcatSpreadable: 2 ,
        iterator: 3 ,
        match: 4 ,
        matchAll: 5 ,
        replace: 6 ,
        search: 7 ,
        species: 8 ,
        split: 9 ,
        toPrimitive: 10 ,
        toStringTag: 11 ,
        unscopables: 12
    });

    var asString = StrCls;

    var GLOBAL_CONFIG_KEY = "__tsUtils$gblCfg";
    var _globalCfg;
    function _getGlobalValue() {
        var result;
        if (typeof globalThis !== UNDEFINED) {
            result = globalThis;
        }
        if (!result && typeof self !== UNDEFINED) {
            result = self;
        }
        if (!result && typeof window !== UNDEFINED) {
            result = window;
        }
        if (!result && typeof global !== UNDEFINED) {
            result = global;
        }
        return result;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function _getGlobalConfig() {
        if (!_globalCfg) {
            var gbl = safe(_getGlobalValue).v || {};
            _globalCfg = gbl[GLOBAL_CONFIG_KEY] = gbl[GLOBAL_CONFIG_KEY] || {};
        }
        return _globalCfg;
    }

    var ERROR_TYPE = "[object Error]";
    /*#__NO_SIDE_EFFECTS__*/
    function dumpObj(object, format) {
        var propertyValueDump = EMPTY;
        var objType = ObjProto[TO_STRING][CALL](object);
        if (objType === ERROR_TYPE) {
            object = { stack: asString(object.stack), message: asString(object.message), name: asString(object.name) };
        }
        try {
            propertyValueDump = JSON.stringify(object, NULL_VALUE, format ? ((typeof format === NUMBER) ? format : 4) : UNDEF_VALUE);
            propertyValueDump = (propertyValueDump && propertyValueDump.replace(/"(\w+)"\s*:\s{0,1}/g, "$1: ")) || asString(object);
        }
        catch (e) {
            propertyValueDump = " - " + dumpObj(e, format);
        }
        return objType + ": " + propertyValueDump;
    }

    var _slice;
    var _unwrapInstFunction =  _unwrapFunctionWithPoly;
    var _unwrapFunction =  _unwrapFunctionWithPoly;
    /*#__NO_SIDE_EFFECTS__*/
    function _unwrapFunctionWithPoly(funcName, clsProto, polyFunc) {
        _slice = _slice || ArrProto[SLICE];
        var clsFn = clsProto && clsProto[funcName];
        return function (thisArg) {
            var theFunc = (thisArg && thisArg[funcName]) || clsFn;
            if (theFunc || polyFunc) {
                var theArgs = arguments;
                return (theFunc || polyFunc).apply(thisArg, theFunc ? _slice[CALL](theArgs, 1) : theArgs);
            }
            throwTypeError("\"" + asString(funcName) + "\" not defined for " + dumpObj(thisArg));
        };
    }
    /*#__NO_SIDE_EFFECTS__*/
    function _unwrapProp(propName) {
        return function (thisArg) {
            return thisArg[propName];
        };
    }

    var mathMin = MathCls.min;
    var mathMax = MathCls.max;

    var strSlice = ( /*#__PURE__*/_unwrapFunction(SLICE, StrProto));

    var strSubstring = ( /*#__PURE__*/_unwrapFunction("substring", StrProto));
    var strSubstr = ( /*#__PURE__*/_unwrapFunctionWithPoly("substr", StrProto, polyStrSubstr));
    /*#__NO_SIDE_EFFECTS__*/
    function polyStrSubstr(value, start, length) {
        if (isNullOrUndefined(value)) {
            throwTypeError("'polyStrSubstr called with invalid " + dumpObj(value));
        }
        if (length < 0) {
            return EMPTY;
        }
        start = start || 0;
        if (start < 0) {
            start = mathMax(start + value[LENGTH], 0);
        }
        if (isUndefined(length)) {
            return strSlice(value, start);
        }
        return strSlice(value, start, start + length);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function strLeft(value, count) {
        return strSubstring(value, 0, count);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function strRight(value, count) {
        return count <= 0 ? EMPTY : (value[LENGTH] > count ? strSlice(value, -count) : value);
    }

    var UNIQUE_REGISTRY_ID = "_urid";
    var _polySymbols;
    /*#__NO_SIDE_EFFECTS__*/
    function _globalSymbolRegistry() {
        if (!_polySymbols) {
            var gblCfg = _getGlobalConfig();
            _polySymbols = gblCfg.gblSym = gblCfg.gblSym || { k: {}, s: {} };
        }
        return _polySymbols;
    }
    var _wellKnownSymbolCache;
    /*#__NO_SIDE_EFFECTS__*/
    function polyNewSymbol(description) {
        var theSymbol = {
            description: asString(description),
            toString: function () { return SYMBOL + "(" + description + ")"; }
        };
        theSymbol[POLYFILL_TAG] = true;
        return theSymbol;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function polySymbolFor(key) {
        var registry = _globalSymbolRegistry();
        if (!objHasOwn(registry.k, key)) {
            var newSymbol_1 = polyNewSymbol(key);
            var regId_1 = objKeys(registry.s).length;
            newSymbol_1[UNIQUE_REGISTRY_ID] = function () { return regId_1 + "_" + newSymbol_1[TO_STRING](); };
            registry.k[key] = newSymbol_1;
            registry.s[newSymbol_1[UNIQUE_REGISTRY_ID]()] = asString(key);
        }
        return registry.k[key];
    }
    /*#__NO_SIDE_EFFECTS__*/
    function polySymbolKeyFor(sym) {
        if (!sym || !sym[TO_STRING] || strSubstring(sym[TO_STRING](), 0, 6) != SYMBOL) {
            throwTypeError(sym + " is not a symbol");
        }
        var regId = sym[POLYFILL_TAG] && sym[UNIQUE_REGISTRY_ID] && sym[UNIQUE_REGISTRY_ID]();
        return regId ? _globalSymbolRegistry().s[regId] : undefined;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function polyGetKnownSymbol(name) {
        !_wellKnownSymbolCache && (_wellKnownSymbolCache = {});
        var result;
        var knownName = _wellKnownSymbolMap[name];
        if (knownName) {
            result = _wellKnownSymbolCache[knownName] = _wellKnownSymbolCache[knownName] || polyNewSymbol(SYMBOL + "." + knownName);
        }
        return result;
    }

    var propMap = {
        e: "enumerable",
        c: "configurable",
        v: VALUE,
        w: "writable",
        g: "get",
        s: "set"
    };
    /*#__NO_SIDE_EFFECTS__*/
    function _createProp(value) {
        var prop = {};
        prop[propMap["c"]] = true;
        prop[propMap["e"]] = true;
        if (value.l) {
            prop.get = function () { return value.l.v; };
            var desc = objGetOwnPropertyDescriptor(value.l, "v");
            if (desc && desc.set) {
                prop.set = function (newValue) {
                    value.l.v = newValue;
                };
            }
        }
        objForEachKey(value, function (key, value) {
            prop[propMap[key]] = isUndefined(value) ? prop[propMap[key]] : value;
        });
        return prop;
    }
    var objDefineProp = ObjClass["defineProperty"];
    var objDefineProperties = ObjClass["defineProperties"];
    function objDefineGet(target, key, value, configurable, enumerable) {
        var _a;
        return objDefineProp(target, key, _createProp((_a = {
                e: enumerable,
                c: configurable
            },
            _a[isFunction(value) ? "g" : "v"] = value,
            _a)));
    }
    function objDefineAccessors(target, prop, getProp, setProp, configurable, enumerable) {
        var desc = {
            e: enumerable,
            c: configurable
        };
        if (getProp) {
            desc.g = getProp;
        }
        if (setProp) {
            desc.s = setProp;
        }
        return objDefineProp(target, prop, _createProp(desc));
    }
    function objDefine(target, key, propDesc) {
        return objDefineProp(target, key, _createProp(propDesc));
    }
    function objDefineProps(target, propDescMap) {
        var props = {};
        objForEachKey(propDescMap, function (key, value) {
            props[key] = _createProp(value);
        });
        return objDefineProperties(target, props);
    }

    var _globalLazyTestHooks;
    function _initTestHooks() {
        _globalLazyTestHooks = _getGlobalConfig();
    }
    function getLazy(cb) {
        var lazyValue = {};
        !_globalLazyTestHooks && _initTestHooks();
        lazyValue.b = _globalLazyTestHooks.lzy;
        objDefineProp(lazyValue, "v", {
            configurable: true,
            get: function () {
                var result = cb();
                if (!_globalLazyTestHooks.lzy) {
                    objDefineProp(lazyValue, "v", {
                        value: result
                    });
                }
                lazyValue.b = _globalLazyTestHooks.lzy;
                return result;
            }
        });
        return lazyValue;
    }
    function setBypassLazyCache(newValue) {
        !_globalLazyTestHooks && _initTestHooks();
        _globalLazyTestHooks.lzy = newValue;
    }

    /*#__NO_SIDE_EFFECTS__*/
    function safeGetLazy(cb, defValue) {
        return getLazy(function () {
            var result = safe(cb);
            return result.e ? defValue : result.v;
        });
    }

    /*#__NO_SIDE_EFFECTS__*/
    function createCachedValue(value) {
        return objDefineProp({
            toJSON: function () { return value; }
        }, "v", { value: value });
    }
    /*#__NO_SIDE_EFFECTS__*/
    function createDeferredCachedValue(cb) {
        return objDefineProp({}, "v", {
            get: function () {
                var result = cb();
                objDefineProp(this, "v", {
                    value: result,
                    enumerable: true
                });
                return result;
            },
            enumerable: true,
            configurable: true
        });
    }

    var WINDOW = "window";
    var _cachedGlobal;
    var _cachedWindow;
    var _cachedDocument;
    var _cachedNavigator;
    var _cachedHistory;
    var _isWebWorker;
    var _isNode;
    /*#__NO_SIDE_EFFECTS__*/
    function lazySafeGetInst(name) {
        return getLazy(function () { return safe((getInst), [name]).v || UNDEF_VALUE; });
    }
    /*#__NO_SIDE_EFFECTS__*/
    function getGlobal(useCached) {
        !_globalLazyTestHooks && _initTestHooks();
        (!_cachedGlobal || useCached === false || _globalLazyTestHooks.lzy) && (_cachedGlobal = createCachedValue(safe(_getGlobalValue).v || NULL_VALUE));
        return _cachedGlobal.v;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function getInst(name, useCached) {
        var gbl = (!_cachedGlobal || useCached === false) ? getGlobal(useCached) : _cachedGlobal.v;
        if (gbl && gbl[name]) {
            return gbl[name];
        }
        if (name === WINDOW && _cachedWindow) {
            return _cachedWindow.v;
        }
        return NULL_VALUE;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function hasDocument() {
        return !!getDocument();
    }
    /*#__NO_SIDE_EFFECTS__*/
    function getDocument() {
        !_globalLazyTestHooks && _initTestHooks();
        (!_cachedDocument || _globalLazyTestHooks.lzy) && (_cachedDocument = createCachedValue(safe((getInst), ["document"]).v));
        return _cachedDocument.v;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function hasWindow() {
        return !!getWindow();
    }
    /*#__NO_SIDE_EFFECTS__*/
    function getWindow() {
        !_globalLazyTestHooks && _initTestHooks();
        (!_cachedWindow || _globalLazyTestHooks.lzy) && (_cachedWindow = createCachedValue(safe((getInst), [WINDOW]).v));
        return _cachedWindow.v;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function hasNavigator() {
        return !!getNavigator();
    }
    /*#__NO_SIDE_EFFECTS__*/
    function getNavigator() {
        !_globalLazyTestHooks && _initTestHooks();
        (!_cachedNavigator || _globalLazyTestHooks.lzy) && (_cachedNavigator = createCachedValue(safe((getInst), ["navigator"]).v));
        return _cachedNavigator.v;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function hasHistory() {
        return !!getHistory();
    }
    /*#__NO_SIDE_EFFECTS__*/
    function getHistory() {
        !_globalLazyTestHooks && _initTestHooks();
        (!_cachedHistory || _globalLazyTestHooks.lzy) && (_cachedHistory = createCachedValue(safe((getInst), ["history"]).v));
        return _cachedHistory.v;
    }
    function isNode() {
        !_isNode && (_isNode = createCachedValue(!!safe(function () { return (process && (process.versions || {}).node); }).v));
        return _isNode.v;
    }
    function isWebWorker() {
        !_isWebWorker && (_isWebWorker = createCachedValue(!!safe(function () { return self && self instanceof WorkerGlobalScope; }).v));
        return _isWebWorker.v;
    }

    var _symbol;
    var _symbolFor;
    var _symbolKeyFor;
    function _initSymbol() {
        if (!_symbol || !_symbol.b) {
            _symbol = lazySafeGetInst(SYMBOL);
            _symbolFor = safeGetLazy(function () { return (_symbol.v ? _symbol.v["for"] : UNDEF_VALUE); }, UNDEF_VALUE);
            _symbolKeyFor = safeGetLazy(function () { return (_symbol.v ? _symbol.v["keyFor"] : UNDEF_VALUE); }, UNDEF_VALUE);
        }
    }
    var isSymbol = ( /*#__PURE__*/_createIs("symbol"));
    /*#__NO_SIDE_EFFECTS__*/
    function hasSymbol() {
        return !!getSymbol();
    }
    /*#__NO_SIDE_EFFECTS__*/
    function getSymbol() {
        !_globalLazyTestHooks && _initTestHooks();
        (!_symbol || _globalLazyTestHooks.lzy) && _initSymbol();
        return _symbol.v;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function getKnownSymbol(name, noPoly) {
        var knownName = _wellKnownSymbolMap[name];
        !_globalLazyTestHooks && _initTestHooks();
        (!_symbol || _globalLazyTestHooks.lzy) && _initSymbol();
        return _symbol.v ? _symbol.v[knownName || name] : (!noPoly ? polyGetKnownSymbol(name) : UNDEF_VALUE);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function newSymbol(description, noPoly) {
        !_globalLazyTestHooks && _initTestHooks();
        (!_symbol || _globalLazyTestHooks.lzy) && _initSymbol();
        return _symbol.v ? _symbol.v(description) : (!noPoly ? polyNewSymbol(description) : NULL_VALUE);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function symbolFor(key) {
        !_globalLazyTestHooks && _initTestHooks();
        (!_symbolFor || !_symbol || _globalLazyTestHooks.lzy) && _initSymbol();
        return (_symbolFor.v || polySymbolFor)(key);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function symbolKeyFor(sym) {
        !_globalLazyTestHooks && _initTestHooks();
        (!_symbolKeyFor || !_symbol || _globalLazyTestHooks.lzy) && _initSymbol();
        return (_symbolKeyFor.v || polySymbolKeyFor)(sym);
    }

    /*#__NO_SIDE_EFFECTS__*/
    function isIterator(value) {
        return !!value && isFunction(value.next);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function isIterable(value) {
        return !isStrictNullOrUndefined(value) && isFunction(value[getKnownSymbol(3 )]);
    }

    var _iterSymbol$1;
    function iterForOf(iter, callbackfn, thisArg) {
        if (iter) {
            if (!isIterator(iter)) {
                !_iterSymbol$1 && (_iterSymbol$1 = createCachedValue(getKnownSymbol(3 )));
                iter = iter[_iterSymbol$1.v] ? iter[_iterSymbol$1.v]() : null;
            }
            if (isIterator(iter)) {
                var err = void 0;
                var iterResult = void 0;
                try {
                    var count = 0;
                    while (!(iterResult = iter.next())[DONE]) {
                        if (callbackfn[CALL](thisArg || iter, iterResult[VALUE], count, iter) === -1) {
                            break;
                        }
                        count++;
                    }
                }
                catch (failed) {
                    err = { e: failed };
                    if (iter.throw) {
                        iterResult = null;
                        iter.throw(err);
                    }
                }
                finally {
                    try {
                        if (iterResult && !iterResult[DONE]) {
                            iter.return && iter.return(iterResult);
                        }
                    }
                    finally {
                        if (err) {
                            throw err.e;
                        }
                    }
                }
            }
        }
    }

    var fnApply = ( /*#__PURE__*/_unwrapInstFunction("apply"));

    function arrAppend(target, elms) {
        if (!isUndefined(elms) && target) {
            if (isArray(elms)) {
                fnApply(target.push, target, elms);
            }
            else if (isIterator(elms) || isIterable(elms)) {
                iterForOf(elms, function (elm) {
                    target.push(elm);
                });
            }
            else {
                target.push(elms);
            }
        }
        return target;
    }

    var arrEvery = /*#__PURE__*/ _unwrapFunction("every", ArrProto);
    var arrFilter = /*#__PURE__*/ _unwrapFunction("filter", ArrProto);

    function arrForEach(theArray, callbackfn, thisArg) {
        if (theArray) {
            var len = theArray[LENGTH] >>> 0;
            for (var idx = 0; idx < len; idx++) {
                if (idx in theArray) {
                    if (callbackfn[CALL](thisArg || theArray, theArray[idx], idx, theArray) === -1) {
                        break;
                    }
                }
            }
        }
    }

    var arrIndexOf = ( /*#__PURE__*/_unwrapFunction(INDEX_OF, ArrProto));
    var arrLastIndexOf = ( /*#__PURE__*/_unwrapFunction(LAST_INDEX_OF, ArrProto));

    var arrMap = ( /*#__PURE__*/_unwrapFunction("map", ArrProto));

    var arrSlice = ( /*#__PURE__*/_unwrapFunction(SLICE, ArrProto));

    /*#__NO_SIDE_EFFECTS__*/
    function polyIsArray(value) {
        if (isNullOrUndefined(value)) {
            return false;
        }
        return objToString(value) === "[object Array]";
    }
    /*#__NO_SIDE_EFFECTS__*/
    function polyArrIncludes(theArray, searchElement, fromIndex) {
        return arrIndexOf(theArray, searchElement, fromIndex) !== -1;
    }
    function polyArrFind(theArray, callbackFn, thisArg) {
        var result;
        var idx = polyArrFindIndex(theArray, callbackFn, thisArg);
        return idx !== -1 ? theArray[idx] : result;
    }
    function polyArrFindIndex(theArray, callbackFn, thisArg) {
        var result = -1;
        arrForEach(theArray, function (value, index) {
            if (callbackFn[CALL](thisArg | theArray, value, index, theArray)) {
                result = index;
                return -1;
            }
        });
        return result;
    }
    function polyArrFindLast(theArray, callbackFn, thisArg) {
        var result;
        var idx = polyArrFindLastIndex(theArray, callbackFn, thisArg);
        return idx !== -1 ? theArray[idx] : result;
    }
    function polyArrFindLastIndex(theArray, callbackFn, thisArg) {
        var result = -1;
        var len = theArray[LENGTH] >>> 0;
        for (var idx = len - 1; idx >= 0; idx--) {
            if (idx in theArray && callbackFn[CALL](thisArg | theArray, theArray[idx], idx, theArray)) {
                result = idx;
                break;
            }
        }
        return result;
    }
    function polyArrFrom(theValue, mapFn, thisArg) {
        if (isArray(theValue)) {
            var result_1 = arrSlice(theValue);
            return mapFn ? arrMap(result_1, mapFn, thisArg) : result_1;
        }
        var result = [];
        iterForOf(theValue, function (value, cnt) {
            return result.push(mapFn ? mapFn[CALL](thisArg, value, cnt) : value);
        });
        return result;
    }

    var arrFind = /*#__PURE__*/ _unwrapFunctionWithPoly("find", ArrProto, polyArrFind);
    var arrFindIndex = /*#__PURE__*/ _unwrapFunctionWithPoly("findIndex", ArrProto, polyArrFindIndex);
    var arrFindLast = /*#__PURE__*/ _unwrapFunctionWithPoly("findLast", ArrProto, polyArrFindLast);
    var arrFindLastIndex = /*#__PURE__*/ _unwrapFunctionWithPoly("findLastIndex", ArrProto, polyArrFindLastIndex);

    var arrFrom = ArrCls.from || polyArrFrom;

    var arrIncludes = ( /*#__PURE__*/_unwrapFunctionWithPoly("includes", ArrProto, polyArrIncludes));
    var arrContains = arrIncludes;

    var arrReduce = ( /*#__PURE__*/_unwrapFunction("reduce", ArrProto));

    var arrSome = ( /*#__PURE__*/_unwrapFunction("some", ArrProto));

    var fnBind = ( /*#__PURE__*/_unwrapInstFunction("bind"));

    var fnCall = ( /*#__PURE__*/_unwrapInstFunction(CALL));

    function createFnDeferredProxy(hostFn, funcName) {
        return function () {
            var theArgs = ArrProto[SLICE][CALL](arguments);
            var theHost = hostFn();
            return fnApply(theHost[funcName], theHost, theArgs);
        };
    }
    function createProxyFuncs(target, host, funcDefs) {
        if (target && host && isArray(funcDefs)) {
            var isDeferred_1 = isFunction(host);
            arrForEach(funcDefs, function (funcDef) {
                var targetName = (funcDef.as || funcDef.n);
                if (funcDef.rp === false && target[targetName]) {
                    return;
                }
                target[targetName] = isDeferred_1 ?
                    createFnDeferredProxy(host, funcDef.n) :
                    fnBind(host[funcDef.n], host);
            });
        }
        return target;
    }

    var _iterSymbol;
    /*#__NO_SIDE_EFFECTS__*/
    function readArgs(theArgs, start, end) {
        if (!objHasOwn(theArgs, LENGTH)) {
            !_iterSymbol && (_iterSymbol = createCachedValue(hasSymbol() && getKnownSymbol(3 )));
            var iterFn = _iterSymbol.v && theArgs[_iterSymbol.v];
            if (iterFn) {
                var values_1 = [];
                var from_1 = (start === UNDEF_VALUE || start < 0) ? 0 : start;
                var to_1 = end < 0 || start < 0 ? UNDEF_VALUE : end;
                iterForOf(iterFn[CALL](theArgs), function (value, cnt) {
                    if (to_1 !== UNDEF_VALUE && cnt >= to_1) {
                        return -1;
                    }
                    if (cnt >= from_1) {
                        values_1.push(value);
                    }
                });
                if ((start === UNDEF_VALUE || start >= 0) && (end === UNDEF_VALUE || end >= 0)) {
                    return values_1;
                }
                theArgs = values_1;
            }
        }
        return arrSlice(theArgs, start, end);
    }

    var objCreate = ObjClass["create"] || polyObjCreate;
    /*#__NO_SIDE_EFFECTS__*/
    function polyObjCreate(obj) {
        if (!obj) {
            return {};
        }
        var type = typeof obj;
        if (type !== OBJECT && type !== FUNCTION) {
            throwTypeError("Prototype must be an Object or function: " + dumpObj(obj));
        }
        function tempFunc() { }
        tempFunc[PROTOTYPE] = obj;
        return new tempFunc();
    }

    var _isProtoArray;
    function objSetPrototypeOf(obj, proto) {
        var fn = ObjClass["setPrototypeOf"] ||
            function (d, b) {
                !_isProtoArray && (_isProtoArray = getLazy(function () {
                    var _a;
                    return ((_a = {}, _a[__PROTO__] = [], _a) instanceof Array);
                }));
                _isProtoArray.v ? d[__PROTO__] = b : objForEachKey(b, function (key, value) { return d[key] = value; });
            };
        return fn(obj, proto);
    }

    function _createCustomError(name, d, b) {
        safe(objDefine, [d, NAME, { v: name, c: true, e: false }]);
        d = objSetPrototypeOf(d, b);
        function __() {
            this.constructor = d;
            safe(objDefine, [this, NAME, { v: name, c: true, e: false }]);
        }
        d[PROTOTYPE] = b === NULL_VALUE ? objCreate(b) : (__[PROTOTYPE] = b[PROTOTYPE], new __());
        return d;
    }
    function _setName(baseClass, name) {
        name && (baseClass[NAME] = name);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function createCustomError(name, constructCb, errorBase) {
        var theBaseClass = errorBase || Error;
        var orgName = theBaseClass[PROTOTYPE][NAME];
        var captureFn = Error.captureStackTrace;
        return _createCustomError(name, function () {
            var _this = this;
            var theArgs = arguments;
            try {
                safe(_setName, [theBaseClass, name]);
                var _self = fnApply(theBaseClass, _this, ArrProto[SLICE][CALL](theArgs)) || _this;
                if (_self !== _this) {
                    var orgProto = objGetPrototypeOf(_this);
                    if (orgProto !== objGetPrototypeOf(_self)) {
                        objSetPrototypeOf(_self, orgProto);
                    }
                }
                captureFn && captureFn(_self, _this[CONSTRUCTOR]);
                constructCb && constructCb(_self, theArgs);
                return _self;
            }
            finally {
                safe(_setName, [theBaseClass, orgName]);
            }
        }, theBaseClass);
    }
    var _unsupportedError;
    function throwUnsupported(message) {
        if (!_unsupportedError) {
            _unsupportedError = createCustomError("UnsupportedError");
        }
        throw new _unsupportedError(message);
    }

    /*#__NO_SIDE_EFFECTS__*/
    function utcNow() {
        return (Date.now || polyUtcNow)();
    }
    /*#__NO_SIDE_EFFECTS__*/
    function polyUtcNow() {
        return new Date().getTime();
    }

    /*#__NO_SIDE_EFFECTS__*/
    function _createTrimFn(exp) {
        return function _doTrim(value) {
            if (isNullOrUndefined(value)) {
                throwTypeError("strTrim called [" + dumpObj(value) + "]");
            }
            if (value && value.replace) {
                value = value.replace(exp, EMPTY);
            }
            return value;
        };
    }
    var polyStrTrim = ( /*#__PURE__*/_createTrimFn(/^\s+|(?=\s)\s+$/g));
    var polyStrTrimStart = ( /*#__PURE__*/_createTrimFn(/^\s+/g));
    var polyStrTrimEnd = ( /*#__PURE__*/_createTrimFn(/(?=\s)\s+$/g));

    var strTrim = ( /*#__PURE__*/_unwrapFunctionWithPoly("trim", StrProto, polyStrTrim));
    var strTrimStart = ( /*#__PURE__*/_unwrapFunctionWithPoly("trimStart", StrProto, polyStrTrimStart));
    var strTrimLeft = strTrimStart;
    var strTrimEnd = ( /*#__PURE__*/_unwrapFunctionWithPoly("trimEnd", StrProto, polyStrTrimEnd));
    var strTrimRight = strTrimEnd;

    var strUpper = ( /*#__PURE__*/_unwrapFunction("toUpperCase", StrProto));
    var strLower = ( /*#__PURE__*/_unwrapFunction("toLowerCase", StrProto));

    /*#__NO_SIDE_EFFECTS__*/
    function _convertCase(value, newPrefix, upperWord) {
        return strTrim(asString(value)).replace(/((_|\W)+(\w){0,1}|([a-z])([A-Z]))/g, function (_match, _g1, _g2, wordStart, upperPrefix, upperLetter) {
            var convertMatch = wordStart || upperLetter || EMPTY;
            if (upperWord) {
                convertMatch = strUpper(convertMatch);
            }
            return (upperPrefix || EMPTY) + newPrefix + convertMatch;
        });
    }
    /*#__NO_SIDE_EFFECTS__*/
    function strLetterCase(value) {
        return asString(value).replace(/(_|\b)\w/g, strUpper);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function strCamelCase(value, upperFirst) {
        var result = _convertCase(value, "", true);
        return result.replace(/^\w/, upperFirst ? strUpper : strLower);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function strKebabCase(value, scream) {
        var result = _convertCase(value, "-");
        return (scream ? strUpper : strLower)(result);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function strSnakeCase(value, scream) {
        var result = _convertCase(value, "_");
        return (scream ? strUpper : strLower)(result);
    }

    var mathFloor = MathCls.floor;
    var mathCeil = MathCls.ceil;

    var mathTrunc = MathCls.trunc || polyMathTrunc;
    /*#__NO_SIDE_EFFECTS__*/
    function polyMathTrunc(value) {
        var theValue = +value;
        return (theValue > 0 ? mathFloor : mathCeil)(theValue);
    }

    /*#__NO_SIDE_EFFECTS__*/
    function mathToInt(value, throwInfinity) {
        var result = +value;
        if (result == Infinity && throwInfinity) {
            throwRangeError("invalid value [" + dumpObj(value) + "]");
        }
        return result !== result || result === 0 ? 0 : mathTrunc(result);
    }

    var strRepeat = ( /*#__PURE__*/_unwrapFunctionWithPoly("repeat", StrProto, polyStrRepeat));
    /*#__NO_SIDE_EFFECTS__*/
    function polyStrRepeat(value, count) {
        if (isNullOrUndefined(value)) {
            throwTypeError("can't convert [" + dumpObj(value) + "]");
        }
        count = mathToInt(count, true);
        if (count < 0) {
            throwRangeError("invalid count must be >= 0 && < Infinity");
        }
        var pad = isString(value) ? value : asString(value);
        var result = EMPTY;
        for (; count > 0; (count >>>= 1) && (pad += pad)) {
            if (count & 1) {
                result += pad;
            }
        }
        return result;
    }

    /*#__NO_SIDE_EFFECTS__*/
    function _padValue(value, targetLength, padString) {
        var result = EMPTY;
        targetLength = mathToInt(targetLength, true);
        targetLength >>= 0;
        var len = value[LENGTH];
        if (len < targetLength) {
            result = isNullOrUndefined(padString) ? " " : asString(padString);
            targetLength = targetLength - len;
            if (targetLength > result[LENGTH]) {
                result = strRepeat(result, mathCeil(targetLength / result[LENGTH]));
            }
            if (result[LENGTH] > targetLength) {
                result = strSubstring(result, 0, targetLength);
            }
        }
        return result;
    }
    var strPadStart = ( /*#__PURE__*/_unwrapFunctionWithPoly("padStart", StrProto, polyStrPadStart));
    var strPadEnd = ( /*#__PURE__*/_unwrapFunctionWithPoly("padEnd", StrProto, polyStrPadEnd));
    /*#__NO_SIDE_EFFECTS__*/
    function polyStrPadStart(value, targetLength, padString) {
        return _padValue(value, targetLength, padString) + value;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function polyStrPadEnd(value, targetLength, padString) {
        return value + _padValue(value, targetLength, padString);
    }

    var DBL_QUOTE = "\"";
    var INVALID_JS_NAME = /([^\w\d_$])/g;
    var _htmlEntityCache;
    /*#__NO_SIDE_EFFECTS__*/
    function normalizeJsName(jsName, camelCase) {
        var result = asString(jsName).replace(INVALID_JS_NAME, "_");
        return !isUndefined(camelCase) ? strCamelCase(result, !camelCase) : result;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function encodeAsJson(value, format) {
        var result;
        if (isString(value)) {
            result = DBL_QUOTE + value.replace(/[^\w .,\-!@#$%\^&*\(\)_+={}\[\]:;|<>?]/g, function (match) {
                if (match === DBL_QUOTE || match === "\\") {
                    return "\\" + match;
                }
                var hex = match.charCodeAt(0)[TO_STRING](16);
                return "\\u" + strPadStart(strUpper(hex), 4, "0");
            }) + DBL_QUOTE;
        }
        else {
            try {
                result = JSON.stringify(value, NULL_VALUE, format ? (isNumber(format) ? format : 4) : UNDEF_VALUE);
            }
            catch (e) {
                result = DBL_QUOTE + dumpObj(e) + DBL_QUOTE;
            }
        }
        return result;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function encodeAsHtml(value) {
        !_htmlEntityCache && (_htmlEntityCache = getLazy(function () {
            var _a;
            return _a = {
                    "&": "amp",
                    "<": "lt",
                    ">": "gt"
                },
                _a[DBL_QUOTE] = "quot",
                _a["'"] = "#39",
                _a;
        }));
        return asString(value).replace(/[&<>"']/g, function (match) { return "&" + _htmlEntityCache.v[match] + ";"; });
    }

    var _fnToString;
    var _objCtrFnString;
    var _gblWindow;
    /*#__NO_SIDE_EFFECTS__*/
    function isPlainObject(value) {
        if (!value || typeof value !== OBJECT) {
            return false;
        }
        if (!_gblWindow) {
            _gblWindow = hasWindow() ? getWindow() : true;
        }
        var result = false;
        if (value !== _gblWindow) {
            if (!_objCtrFnString) {
                _fnToString = Function[PROTOTYPE][TO_STRING];
                _objCtrFnString = _fnToString[CALL](ObjClass);
            }
            try {
                var proto = objGetPrototypeOf(value);
                result = !proto;
                if (!result) {
                    if (objHasOwnProperty(proto, CONSTRUCTOR)) {
                        proto = proto[CONSTRUCTOR];
                    }
                    result = proto && typeof proto === FUNCTION && _fnToString[CALL](proto) === _objCtrFnString;
                }
            }
            catch (ex) {
            }
        }
        return result;
    }

    var _defaultDeepCopyHandler = function (details) {
        details.value && plainObjDeepCopyHandler(details);
        return true;
    };
    var defaultDeepCopyHandlers = [
        arrayDeepCopyHandler,
        plainObjDeepCopyHandler,
        functionDeepCopyHandler,
        dateDeepCopyHandler
    ];
    function _getSetVisited(visitMap, source, newPath, cb) {
        var theEntry;
        arrForEach(visitMap, function (entry) {
            if (entry.k === source) {
                theEntry = entry;
                return -1;
            }
        });
        if (!theEntry) {
            theEntry = { k: source, v: source };
            visitMap.push(theEntry);
            cb(theEntry);
        }
        return theEntry.v;
    }
    function _deepCopy(visitMap, value, ctx, key) {
        var userHandler = ctx.handler;
        var newPath = ctx.path ? (key ? ctx.path.concat(key) : ctx.path) : [];
        var newCtx = {
            handler: ctx.handler,
            src: ctx.src,
            path: newPath
        };
        var theType = typeof value;
        var isPlain = false;
        var isPrim = false;
        if (value && theType === OBJECT) {
            isPlain = isPlainObject(value);
        }
        else {
            isPrim = value === NULL_VALUE || isPrimitiveType(theType);
        }
        var details = {
            type: theType,
            isPrim: isPrim,
            isPlain: isPlain,
            value: value,
            result: value,
            path: newPath,
            origin: ctx.src,
            copy: function (source, newKey) {
                return _deepCopy(visitMap, source, newKey ? newCtx : ctx, newKey);
            },
            copyTo: function (target, source) {
                return _copyProps(visitMap, target, source, newCtx);
            }
        };
        if (!details.isPrim) {
            return _getSetVisited(visitMap, value, newPath, function (newEntry) {
                objDefine(details, "result", {
                    g: function () {
                        return newEntry.v;
                    },
                    s: function (newValue) {
                        newEntry.v = newValue;
                    }
                });
                var idx = 0;
                var handler = userHandler;
                while (!(handler || (idx < defaultDeepCopyHandlers.length ? defaultDeepCopyHandlers[idx++] : _defaultDeepCopyHandler))[CALL](ctx, details)) {
                    handler = NULL_VALUE;
                }
            });
        }
        if (userHandler && userHandler[CALL](ctx, details)) {
            return details.result;
        }
        return value;
    }
    function _copyProps(visitMap, target, source, ctx) {
        if (!isNullOrUndefined(source)) {
            for (var key in source) {
                target[key] = _deepCopy(visitMap, source[key], ctx, key);
            }
        }
        return target;
    }
    function objCopyProps(target, source, handler) {
        var ctx = {
            handler: handler,
            src: source,
            path: []
        };
        return _copyProps([], target, source, ctx);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function objDeepCopy(source, handler) {
        var ctx = {
            handler: handler,
            src: source
        };
        return _deepCopy([], source, ctx);
    }
    function arrayDeepCopyHandler(details) {
        var value = details.value;
        if (isArray(value)) {
            var target = details.result = [];
            target.length = value.length;
            details.copyTo(target, value);
            return true;
        }
        return false;
    }
    function dateDeepCopyHandler(details) {
        var value = details.value;
        if (isDate(value)) {
            details.result = new Date(value.getTime());
            return true;
        }
        return false;
    }
    function functionDeepCopyHandler(details) {
        if (details.type === FUNCTION) {
            return true;
        }
        return false;
    }
    function plainObjDeepCopyHandler(details) {
        var value = details.value;
        if (value && details.isPlain) {
            var target = details.result = {};
            details.copyTo(target, value);
            return true;
        }
        return false;
    }

    function _doExtend(target, theArgs) {
        arrForEach(theArgs, function (theArg) {
            objCopyProps(target, theArg);
        });
        return target;
    }
    function deepExtend(target, obj1, obj2, obj3, obj4, obj5, obj6) {
        return _doExtend(objDeepCopy(target) || {}, ArrProto[SLICE][CALL](arguments));
    }
    function objExtend(target, obj1, obj2, obj3, obj4, obj5, obj6) {
        return _doExtend(target || {}, ArrProto[SLICE][CALL](arguments));
    }

    var getLength = ( /*#__PURE__*/_unwrapProp(LENGTH));

    /*#__NO_SIDE_EFFECTS__*/
    function getIntValue(value, defValue) {
        if (!isNullOrUndefined(value)) {
            if (isNumber(value)) {
                return value;
            }
            var theValue = parseInt(value, 10);
            return isNaN(theValue) ? defValue : theValue;
        }
        return defValue;
    }

    var _perf;
    /*#__NO_SIDE_EFFECTS__*/
    function hasPerformance() {
        return !!getPerformance();
    }
    /*#__NO_SIDE_EFFECTS__*/
    function getPerformance() {
        !_globalLazyTestHooks && _initTestHooks();
        (!_perf || (!_perf.b && _globalLazyTestHooks.lzy)) && (_perf = lazySafeGetInst("performance"));
        return _perf.v;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function perfNow() {
        var perf = getPerformance();
        if (perf && perf.now) {
            return perf.now();
        }
        return utcNow();
    }
    /*#__NO_SIDE_EFFECTS__*/
    function elapsedTime(startTime) {
        return perfNow() - startTime;
    }

    var MATCH_ANY = "(.*)";
    var MATCH_SINGLE = "(.)";
    function _createRegExp(value, escapeRgx, replaceFn, ignoreCase, fullMatch) {
        return new RegExp((fullMatch ? "^" : EMPTY) + replaceFn(value.replace(escapeRgx, "\\$1")) + (fullMatch ? "$" : EMPTY), ignoreCase ? "i" : "");
    }
    /*#__NO_SIDE_EFFECTS__*/
    function createWildcardRegex(value, ignoreCase, fullMatch) {
        return _createRegExp(asString(value), /([-+|^$#.\?{}()\[\]\\/\"\'])/g, function (value) {
            return value.replace(/\*/g, MATCH_ANY);
        }, !!ignoreCase, fullMatch);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function createFilenameRegex(value, ignoreCase, fullMatch) {
        return _createRegExp(asString(value), /([-+|^$#.{}()\\\/\[\]\"\'])/g, function (value) {
            return value.replace(/(\\\\|\\\/|\*|\?)/g, function (_all, g1) {
                if (g1 == "\\/" || g1 == "\\\\") {
                    return "[\\\\\\/]{1}";
                }
                return g1 == "*" ? MATCH_ANY : MATCH_SINGLE;
            });
        }, !!ignoreCase, fullMatch);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function makeGlobRegex(value, ignoreCase, fullMatch) {
        return _createRegExp(asString(value), /([-+|^$#.{}()\\\/\[\]\"\'])/g, function (value) {
            return value.replace(/(\*\*\\[\\\/]|\\\\|\\\/|\*\*|\*|\?)/g, function (_all, g1) {
                if (g1 == "**\\/" || g1 == "**\\\\") {
                    return "(.*[\\\\\\/])*";
                }
                if (g1 === "\\/" || g1 == "\\\\") {
                    return "[\\\\\\/]{1}";
                }
                if (g1 === "**") {
                    return MATCH_ANY;
                }
                return g1 === "*" ? "([^\\\\\\/]*)" : "([^\\\\\\/]{1})";
            });
        }, !!ignoreCase, fullMatch);
    }

    /*#__NO_SIDE_EFFECTS__*/
    function _checkLength(value, props) {
        var result;
        arrForEach(props, function (prop) {
            if (prop in value) {
                var propValue = value[prop];
                result = (isFunction(propValue) ? propValue() : propValue) > 0;
                return -1;
            }
        });
        return result;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function _hasValue(value, depth) {
        var result = value === false || value === 0;
        if (!result && !isNullOrUndefined(value)) {
            if (isArray(value)) {
                result = value[LENGTH] > 0;
            }
            else if (isDate(value)) {
                result = !isNaN(value.getTime());
            }
            else if (isBoolean(value)) {
                return true;
            }
            else if (isObject(value)) {
                try {
                    var chkValue = _checkLength(value, [LENGTH, "byteLength", "size", "count"]);
                    if (isBoolean(chkValue)) {
                        return chkValue;
                    }
                    if (isFunction(value.valueOf) && depth < 5) {
                        return _hasValue(value.valueOf(), ++depth);
                    }
                }
                catch (e) {
                }
                return !!objKeys(value)[LENGTH];
            }
            else {
                result = isTruthy(value);
            }
        }
        return result;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function hasValue(value) {
        return _hasValue(value, 0);
    }

    /*#__NO_SIDE_EFFECTS__*/
    function createIterable(ctx) {
        return makeIterable({}, ctx);
    }
    function makeIterable(target, ctx) {
        var itSymbol = getKnownSymbol(3 );
        function _createIterator() {
            return createIterator(ctx);
        }
        target[itSymbol] = _createIterator;
        return target;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function createIterator(ctx) {
        var isDone = false;
        function _value() {
            return ctx.v;
        }
        function _next() {
            var _a;
            isDone = isDone || (ctx.n ? ctx.n(arguments) : true);
            var result = (_a = {},
                _a[DONE] = isDone,
                _a);
            if (!isDone) {
                objDefine(result, VALUE, { g: _value });
            }
            return result;
        }
        function _return(value) {
            var _a;
            isDone = true;
            return _a = {},
                _a[DONE] = true,
                _a[VALUE] = ctx.r && ctx.r(value),
                _a;
        }
        function _throw(e) {
            var _a;
            isDone = true;
            return _a = {},
                _a[DONE] = true,
                _a[VALUE] = ctx.t && ctx.t(e),
                _a;
        }
        var theIterator = {
            next: _next
        };
        if (ctx.r) {
            theIterator.return = _return;
        }
        if (ctx.t) {
            theIterator.throw = _throw;
        }
        return theIterator;
    }

    /*#__NO_SIDE_EFFECTS__*/
    function createArrayIterator(values) {
        var idx = -1;
        var theValues = values ? values.slice() : [];
        var len = theValues[LENGTH];
        function _value() {
            if (idx >= 0 && idx < len) {
                return theValues[idx];
            }
        }
        function _getNext() {
            idx++;
            return idx >= len;
        }
        var ctx = {
            n: _getNext
        };
        objDefine(ctx, "v", { g: _value });
        return createIterator(ctx);
    }

    /*#__NO_SIDE_EFFECTS__*/
    function createRangeIterator(start, end, step) {
        var nextValue = start;
        var theValue = UNDEF_VALUE;
        if (isNullOrUndefined(end)) {
            end = start;
        }
        var theStep = step || ((start <= end) ? 1 : -1);
        function _value() {
            return theValue;
        }
        function _getNext() {
            var isDone = false;
            if (theStep > 0) {
                isDone = nextValue > end;
            }
            else {
                isDone = nextValue < end;
            }
            if (!isDone) {
                theValue = nextValue;
                nextValue += theStep;
            }
            return isDone;
        }
        var ctx = {
            n: _getNext
        };
        objDefine(ctx, "v", { g: _value });
        return createIterator(ctx);
    }

    /*#__NO_SIDE_EFFECTS__*/
    function polyStrSymSplit(value, splitter, limit) {
        var splitFn = splitter && splitter[getKnownSymbol(9 )];
        return splitFn ? splitFn(value, limit) : [value];
    }

    var strSplit = ( /*#__PURE__*/_unwrapFunction("split", StrProto));
    var strSymSplit = ( /*#__PURE__*/_unwrapFunctionWithPoly("split", StrProto, !hasSymbol() ? polyStrSymSplit : null));

    /*#__NO_SIDE_EFFECTS__*/
    function getValueByKey(target, path, defValue) {
        if (!path || !target) {
            return defValue;
        }
        var parts = strSplit(path, ".");
        var cnt = parts.length;
        for (var lp = 0; lp < cnt && !isNullOrUndefined(target); lp++) {
            target = target[parts[lp]];
        }
        return (!isNullOrUndefined(target) ? target : defValue);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function getValueByIter(target, iter, defValue) {
        if (!iter || !target) {
            return defValue;
        }
        iterForOf(iter, function (value) {
            if (isNullOrUndefined(target)) {
                return -1;
            }
            target = target[value];
        });
        return (!isNullOrUndefined(target) ? target : defValue);
    }
    function setValueByKey(target, path, value) {
        if (target && path) {
            var parts = strSplit(path, ".");
            var lastKey = parts.pop();
            arrForEach(parts, function (key) {
                if (isNullOrUndefined(target[key])) {
                    target[key] = {};
                }
                target = target[key];
            });
            target[lastKey] = value;
        }
    }
    function setValueByIter(target, iter, value) {
        if (target && iter) {
            var lastKey_1;
            iterForOf(iter, function (key) {
                if (lastKey_1) {
                    if (isNullOrUndefined(target[lastKey_1])) {
                        target[lastKey_1] = {};
                    }
                    target = target[lastKey_1];
                }
                lastKey_1 = key;
            });
            target[lastKey_1] = value;
        }
    }

    var strEndsWith = ( /*#__PURE__*/_unwrapFunctionWithPoly("endsWith", StrProto, polyStrEndsWith));
    /*#__NO_SIDE_EFFECTS__*/
    function polyStrEndsWith(value, searchString, length) {
        if (!isString(value)) {
            throwTypeError("'" + dumpObj(value) + "' is not a string");
        }
        var searchValue = isString(searchString) ? searchString : asString(searchString);
        var end = !isUndefined(length) && length < value[LENGTH] ? length : value[LENGTH];
        return strSubstring(value, end - searchValue[LENGTH], end) === searchValue;
    }

    var strIndexOf = ( /*#__PURE__*/_unwrapFunction(INDEX_OF, StrProto));
    var strLastIndexOf = ( /*#__PURE__*/_unwrapFunction(LAST_INDEX_OF, StrProto));

    var strIncludes = ( /*#__PURE__*/_unwrapFunctionWithPoly("includes", StrProto, polyStrIncludes));
    var strContains = strIncludes;
    /*#__NO_SIDE_EFFECTS__*/
    function polyStrIncludes(value, searchString, position) {
        if (isRegExp(searchString)) {
            throwTypeError("'searchString' must not be a regular expression" + dumpObj(searchString));
        }
        return strIndexOf(value, asString(searchString), position) !== -1;
    }

    /*#__NO_SIDE_EFFECTS__*/
    function strIsNullOrWhiteSpace(value) {
        if (isString(value)) {
            return value.replace(/[\s\t\r\n\f]+/g, EMPTY) === EMPTY;
        }
        return isNullOrUndefined(value);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function strIsNullOrEmpty(value) {
        if (isString(value)) {
            return value === EMPTY;
        }
        return isNullOrUndefined(value);
    }

    var strStartsWith = ( /*#__PURE__*/_unwrapFunctionWithPoly("startsWith", StrProto, polyStrStartsWith));
    /*#__NO_SIDE_EFFECTS__*/
    function polyStrStartsWith(value, searchString, position) {
        if (!isString(value)) {
            throwTypeError("'" + dumpObj(value) + "' is not a string");
        }
        var searchValue = isString(searchString) ? searchString : asString(searchString);
        var pos = position > 0 ? position : 0;
        return strSubstring(value, pos, pos + searchValue[LENGTH]) === searchValue;
    }

    var REF = "ref";
    var UNREF = "un" + REF;
    var HAS_REF = "hasRef";
    var ENABLED = "enabled";
    function _createTimerHandler(startTimer, refreshFn, cancelFn) {
        var _a;
        var ref = true;
        var timerId = startTimer ? refreshFn(NULL_VALUE) : NULL_VALUE;
        var theTimerHandler;
        var _unref = function () {
            ref = false;
            timerId && timerId[UNREF] && timerId[UNREF]();
            return theTimerHandler;
        };
        var _ref = function () {
            ref = true;
            timerId && timerId[REF] && timerId[REF]();
            return theTimerHandler;
        };
        var _hasRef = function () {
            if (timerId && timerId[HAS_REF]) {
                return timerId[HAS_REF]();
            }
            return ref;
        };
        var _refresh = function () {
            timerId = refreshFn(timerId);
            if (!ref) {
                _unref();
            }
            return theTimerHandler;
        };
        var _cancel = function () {
            timerId && cancelFn(timerId);
            timerId = NULL_VALUE;
        };
        var _setEnabled = function (value) {
            !value && timerId && _cancel();
            value && !timerId && _refresh();
        };
        theTimerHandler = (_a = {
                cancel: _cancel,
                refresh: _refresh
            },
            _a[HAS_REF] = _hasRef,
            _a[REF] = _ref,
            _a[UNREF] = _unref,
            _a[ENABLED] = false,
            _a);
        objDefineProp(theTimerHandler, ENABLED, {
            get: function () { return !!timerId; },
            set: _setEnabled
        });
        return {
            h: theTimerHandler,
            dn: function () {
                timerId = NULL_VALUE;
            }
        };
    }

    function _createTimeoutWith(self, startTimer, overrideFn, theArgs) {
        var isArr = isArray(overrideFn);
        var len = isArr ? overrideFn.length : 0;
        var setFn = (len > 0 ? overrideFn[0] : (!isArr ? overrideFn : UNDEF_VALUE)) || setTimeout;
        var clearFn = (len > 1 ? overrideFn[1] : UNDEF_VALUE) || clearTimeout;
        var timerFn = theArgs[0];
        theArgs[0] = function () {
            handler.dn();
            fnApply(timerFn, self, ArrProto[SLICE][CALL](arguments));
        };
        var handler = _createTimerHandler(startTimer, function (timerId) {
            if (timerId) {
                if (timerId.refresh) {
                    timerId.refresh();
                    return timerId;
                }
                fnApply(clearFn, self, [timerId]);
            }
            return fnApply(setFn, self, theArgs);
        }, function (timerId) {
            fnApply(clearFn, self, [timerId]);
        });
        return handler.h;
    }
    function scheduleTimeout(callback, timeout) {
        return _createTimeoutWith(this, true, UNDEF_VALUE, ArrProto[SLICE][CALL](arguments));
    }
    function scheduleTimeoutWith(overrideFn, callback, timeout) {
        return _createTimeoutWith(this, true, overrideFn, ArrProto[SLICE][CALL](arguments, 1));
    }
    function createTimeout(callback, timeout) {
        return _createTimeoutWith(this, false, UNDEF_VALUE, ArrProto[SLICE][CALL](arguments));
    }
    function createTimeoutWith(overrideFn, callback, timeout) {
        return _createTimeoutWith(this, false, overrideFn, ArrProto[SLICE][CALL](arguments, 1));
    }

    var _hasIdleCallback;
    var _defaultIdleTimeout = 100;
    var _maxExecutionTime = 50;
    /*#__NO_SIDE_EFFECTS__*/
    function hasIdleCallback() {
        !_hasIdleCallback && (_hasIdleCallback = safeGetLazy(function () { return isDefined(requestIdleCallback); }, false));
        return !!(_hasIdleCallback.v ? requestIdleCallback : false);
    }
    function setDefaultIdleTimeout(timeout) {
        _defaultIdleTimeout = timeout;
    }
    function setDefaultMaxExecutionTime(maxTime) {
        _maxExecutionTime = maxTime;
    }
    function scheduleIdleCallback(callback, options) {
        function _createDeadline(timedOut) {
            var startTime = perfNow();
            return {
                didTimeout: timedOut,
                timeRemaining: function () {
                    return _maxExecutionTime - elapsedTime(startTime);
                }
            };
        }
        if (hasIdleCallback()) {
            var handler_1 = _createTimerHandler(true, function (idleId) {
                idleId && cancelIdleCallback(idleId);
                return requestIdleCallback(function (deadline) {
                    handler_1.dn();
                    callback(deadline || _createDeadline(false));
                }, options);
            }, function (idleId) {
                cancelIdleCallback(idleId);
            });
            return handler_1.h;
        }
        var timeout = (options || {}).timeout;
        if (isUndefined(timeout)) {
            timeout = _defaultIdleTimeout;
        }
        return scheduleTimeout(function () {
            callback(_createDeadline(true));
        }, timeout);
    }

    function scheduleInterval(callback, timeout) {
        var self = this;
        var theArguments = ArrProto[SLICE][CALL](arguments);
        var handler = _createTimerHandler(true, function (intervalId) {
            intervalId && clearInterval(intervalId);
            return fnApply(setInterval, self, theArguments);
        }, function (intervalId) {
            fnApply(clearInterval, self, [intervalId]);
        });
        return handler.h;
    }

    exports.arrAppend = arrAppend;
    exports.arrContains = arrContains;
    exports.arrEvery = arrEvery;
    exports.arrFilter = arrFilter;
    exports.arrFind = arrFind;
    exports.arrFindIndex = arrFindIndex;
    exports.arrFindLast = arrFindLast;
    exports.arrFindLastIndex = arrFindLastIndex;
    exports.arrForEach = arrForEach;
    exports.arrFrom = arrFrom;
    exports.arrIncludes = arrIncludes;
    exports.arrIndexOf = arrIndexOf;
    exports.arrLastIndexOf = arrLastIndexOf;
    exports.arrMap = arrMap;
    exports.arrReduce = arrReduce;
    exports.arrSlice = arrSlice;
    exports.arrSome = arrSome;
    exports.arrayDeepCopyHandler = arrayDeepCopyHandler;
    exports.asString = asString;
    exports.createArrayIterator = createArrayIterator;
    exports.createCachedValue = createCachedValue;
    exports.createCustomError = createCustomError;
    exports.createDeferredCachedValue = createDeferredCachedValue;
    exports.createEnum = createEnum;
    exports.createEnumKeyMap = createEnumKeyMap;
    exports.createEnumValueMap = createEnumValueMap;
    exports.createFilenameRegex = createFilenameRegex;
    exports.createFnDeferredProxy = createFnDeferredProxy;
    exports.createIterable = createIterable;
    exports.createIterator = createIterator;
    exports.createProxyFuncs = createProxyFuncs;
    exports.createRangeIterator = createRangeIterator;
    exports.createSimpleMap = createSimpleMap;
    exports.createTimeout = createTimeout;
    exports.createTimeoutWith = createTimeoutWith;
    exports.createTypeMap = createTypeMap;
    exports.createWildcardRegex = createWildcardRegex;
    exports.dateDeepCopyHandler = dateDeepCopyHandler;
    exports.deepExtend = deepExtend;
    exports.dumpObj = dumpObj;
    exports.elapsedTime = elapsedTime;
    exports.encodeAsHtml = encodeAsHtml;
    exports.encodeAsJson = encodeAsJson;
    exports.fnApply = fnApply;
    exports.fnBind = fnBind;
    exports.fnCall = fnCall;
    exports.functionDeepCopyHandler = functionDeepCopyHandler;
    exports.getDocument = getDocument;
    exports.getGlobal = getGlobal;
    exports.getHistory = getHistory;
    exports.getInst = getInst;
    exports.getIntValue = getIntValue;
    exports.getKnownSymbol = getKnownSymbol;
    exports.getLazy = getLazy;
    exports.getLength = getLength;
    exports.getNavigator = getNavigator;
    exports.getPerformance = getPerformance;
    exports.getSymbol = getSymbol;
    exports.getValueByIter = getValueByIter;
    exports.getValueByKey = getValueByKey;
    exports.getWindow = getWindow;
    exports.hasDocument = hasDocument;
    exports.hasHistory = hasHistory;
    exports.hasIdleCallback = hasIdleCallback;
    exports.hasNavigator = hasNavigator;
    exports.hasPerformance = hasPerformance;
    exports.hasSymbol = hasSymbol;
    exports.hasValue = hasValue;
    exports.hasWindow = hasWindow;
    exports.isArray = isArray;
    exports.isArrayBuffer = isArrayBuffer;
    exports.isBlob = isBlob;
    exports.isBoolean = isBoolean;
    exports.isDate = isDate;
    exports.isDefined = isDefined;
    exports.isError = isError;
    exports.isFile = isFile;
    exports.isFormData = isFormData;
    exports.isFunction = isFunction;
    exports.isIterable = isIterable;
    exports.isIterator = isIterator;
    exports.isNode = isNode;
    exports.isNotTruthy = isNotTruthy;
    exports.isNullOrUndefined = isNullOrUndefined;
    exports.isNumber = isNumber;
    exports.isObject = isObject;
    exports.isPlainObject = isPlainObject;
    exports.isPrimitive = isPrimitive;
    exports.isPrimitiveType = isPrimitiveType;
    exports.isPromise = isPromise;
    exports.isPromiseLike = isPromiseLike;
    exports.isRegExp = isRegExp;
    exports.isStrictNullOrUndefined = isStrictNullOrUndefined;
    exports.isStrictUndefined = isStrictUndefined;
    exports.isString = isString;
    exports.isSymbol = isSymbol;
    exports.isThenable = isThenable;
    exports.isTruthy = isTruthy;
    exports.isTypeof = isTypeof;
    exports.isUndefined = isUndefined;
    exports.isWebWorker = isWebWorker;
    exports.iterForOf = iterForOf;
    exports.lazySafeGetInst = lazySafeGetInst;
    exports.makeGlobRegex = makeGlobRegex;
    exports.makeIterable = makeIterable;
    exports.mathCeil = mathCeil;
    exports.mathFloor = mathFloor;
    exports.mathMax = mathMax;
    exports.mathMin = mathMin;
    exports.mathToInt = mathToInt;
    exports.mathTrunc = mathTrunc;
    exports.newSymbol = newSymbol;
    exports.normalizeJsName = normalizeJsName;
    exports.objAssign = objAssign;
    exports.objCopyProps = objCopyProps;
    exports.objCreate = objCreate;
    exports.objDeepCopy = objDeepCopy;
    exports.objDeepFreeze = objDeepFreeze;
    exports.objDefine = objDefine;
    exports.objDefineAccessors = objDefineAccessors;
    exports.objDefineGet = objDefineGet;
    exports.objDefineProp = objDefineProp;
    exports.objDefineProperties = objDefineProperties;
    exports.objDefineProps = objDefineProps;
    exports.objEntries = objEntries;
    exports.objExtend = objExtend;
    exports.objForEachKey = objForEachKey;
    exports.objFreeze = objFreeze;
    exports.objGetOwnPropertyDescriptor = objGetOwnPropertyDescriptor;
    exports.objGetPrototypeOf = objGetPrototypeOf;
    exports.objHasOwn = objHasOwn;
    exports.objHasOwnProperty = objHasOwnProperty;
    exports.objKeys = objKeys;
    exports.objSeal = objSeal;
    exports.objSetPrototypeOf = objSetPrototypeOf;
    exports.objToString = objToString;
    exports.perfNow = perfNow;
    exports.plainObjDeepCopyHandler = plainObjDeepCopyHandler;
    exports.polyArrFind = polyArrFind;
    exports.polyArrFindIndex = polyArrFindIndex;
    exports.polyArrFindLast = polyArrFindLast;
    exports.polyArrFindLastIndex = polyArrFindLastIndex;
    exports.polyArrFrom = polyArrFrom;
    exports.polyArrIncludes = polyArrIncludes;
    exports.polyGetKnownSymbol = polyGetKnownSymbol;
    exports.polyIsArray = polyIsArray;
    exports.polyNewSymbol = polyNewSymbol;
    exports.polyObjEntries = polyObjEntries;
    exports.polyObjHasOwn = polyObjHasOwn;
    exports.polyObjKeys = polyObjKeys;
    exports.polyStrIncludes = polyStrIncludes;
    exports.polyStrSubstr = polyStrSubstr;
    exports.polyStrSymSplit = polyStrSymSplit;
    exports.polyStrTrim = polyStrTrim;
    exports.polyStrTrimEnd = polyStrTrimEnd;
    exports.polyStrTrimStart = polyStrTrimStart;
    exports.polySymbolFor = polySymbolFor;
    exports.polySymbolKeyFor = polySymbolKeyFor;
    exports.polyUtcNow = polyUtcNow;
    exports.readArgs = readArgs;
    exports.safe = safe;
    exports.safeGet = safeGet;
    exports.safeGetLazy = safeGetLazy;
    exports.scheduleIdleCallback = scheduleIdleCallback;
    exports.scheduleInterval = scheduleInterval;
    exports.scheduleTimeout = scheduleTimeout;
    exports.scheduleTimeoutWith = scheduleTimeoutWith;
    exports.setBypassLazyCache = setBypassLazyCache;
    exports.setDefaultIdleTimeout = setDefaultIdleTimeout;
    exports.setDefaultMaxExecutionTime = setDefaultMaxExecutionTime;
    exports.setValueByIter = setValueByIter;
    exports.setValueByKey = setValueByKey;
    exports.strCamelCase = strCamelCase;
    exports.strContains = strContains;
    exports.strEndsWith = strEndsWith;
    exports.strIncludes = strIncludes;
    exports.strIndexOf = strIndexOf;
    exports.strIsNullOrEmpty = strIsNullOrEmpty;
    exports.strIsNullOrWhiteSpace = strIsNullOrWhiteSpace;
    exports.strKebabCase = strKebabCase;
    exports.strLastIndexOf = strLastIndexOf;
    exports.strLeft = strLeft;
    exports.strLetterCase = strLetterCase;
    exports.strLower = strLower;
    exports.strPadEnd = strPadEnd;
    exports.strPadStart = strPadStart;
    exports.strRepeat = strRepeat;
    exports.strRight = strRight;
    exports.strSlice = strSlice;
    exports.strSnakeCase = strSnakeCase;
    exports.strSplit = strSplit;
    exports.strStartsWith = strStartsWith;
    exports.strSubstr = strSubstr;
    exports.strSubstring = strSubstring;
    exports.strSymSplit = strSymSplit;
    exports.strTrim = strTrim;
    exports.strTrimEnd = strTrimEnd;
    exports.strTrimLeft = strTrimLeft;
    exports.strTrimRight = strTrimRight;
    exports.strTrimStart = strTrimStart;
    exports.strUpper = strUpper;
    exports.symbolFor = symbolFor;
    exports.symbolKeyFor = symbolKeyFor;
    exports.throwError = throwError;
    exports.throwRangeError = throwRangeError;
    exports.throwTypeError = throwTypeError;
    exports.throwUnsupported = throwUnsupported;
    exports.utcNow = utcNow;

    return exports;

})({});
//# sourceMappingURL=ts-utils.js.map
