/*
 * NevWare21 - ts-utils Polyfills, v0.10.5
 * https://github.com/nevware21/ts-utils
 * Copyright (c) NevWare21 and contributors. All rights reserved.
 * Licensed under the MIT license.
 */
(function () {
    'use strict';

    var UNDEF_VALUE = undefined;
    var NULL_VALUE = null;
    var EMPTY = "";
    var FUNCTION = "function";
    var NUMBER = "number";
    var OBJECT = "object";
    var PROTOTYPE = "prototype";
    var STRING = "string";
    var UNDEFINED = "undefined";
    var SYMBOL = "Symbol";
    var POLYFILL_TAG = "_polyfill";
    var INDEX_OF = "indexOf";
    var LENGTH = "length";
    var DONE = "done";
    var VALUE = "value";
    var SLICE = "slice";
    var CALL = "call";
    var TO_STRING = "toString";
    var ObjClass = Object;
    var ObjProto = ObjClass[PROTOTYPE];
    var StrCls = String;
    var StrProto = StrCls[PROTOTYPE];
    var MathCls = Math;
    var ArrCls = Array;
    var ArrProto = ArrCls[PROTOTYPE];

    function arrForEach(theArray, callbackfn, thisArg) {
        if (theArray) {
            var len = theArray[LENGTH] >>> 0;
            for (var idx = 0; idx < len; idx++) {
                if (idx in theArray) {
                    if (callbackfn[CALL](thisArg || theArray, theArray[idx], idx, theArray) === -1) {
                        break;
                    }
                }
            }
        }
    }

    var asString = StrCls;

    var ERROR_TYPE = "[object Error]";
    /*#__NO_SIDE_EFFECTS__*/
    function dumpObj(object, format) {
        var propertyValueDump = EMPTY;
        var objType = ObjProto[TO_STRING][CALL](object);
        if (objType === ERROR_TYPE) {
            object = { stack: asString(object.stack), message: asString(object.message), name: asString(object.name) };
        }
        try {
            propertyValueDump = JSON.stringify(object, NULL_VALUE, format ? ((typeof format === NUMBER) ? format : 4) : UNDEF_VALUE);
            propertyValueDump = (propertyValueDump && propertyValueDump.replace(/"(\w+)"\s*:\s{0,1}/g, "$1: ")) || asString(object);
        }
        catch (e) {
            propertyValueDump = " - " + dumpObj(e, format);
        }
        return objType + ": " + propertyValueDump;
    }

    function throwTypeError(message) {
        throw new TypeError(message);
    }
    function throwRangeError(message) {
        throw new RangeError(message);
    }

    var _slice;
    var _unwrapFunction =  _unwrapFunctionWithPoly;
    /*#__NO_SIDE_EFFECTS__*/
    function _unwrapFunctionWithPoly(funcName, clsProto, polyFunc) {
        _slice = _slice || ArrProto[SLICE];
        var clsFn = clsProto && clsProto[funcName];
        return function (thisArg) {
            var theFunc = (thisArg && thisArg[funcName]) || clsFn;
            if (theFunc || polyFunc) {
                var theArgs = arguments;
                return (theFunc || polyFunc).apply(thisArg, theFunc ? _slice[CALL](theArgs, 1) : theArgs);
            }
            throwTypeError("\"" + asString(funcName) + "\" not defined for " + dumpObj(thisArg));
        };
    }

    var arrIndexOf = ( /*#__PURE__*/_unwrapFunction(INDEX_OF, ArrProto));

    var arrMap = ( /*#__PURE__*/_unwrapFunction("map", ArrProto));

    var arrSlice = ( /*#__PURE__*/_unwrapFunction(SLICE, ArrProto));

    function safe(func, argArray) {
        try {
            return {
                v: func.apply(this, argArray)
            };
        }
        catch (e) {
            return { e: e };
        }
    }

    /*#__NO_SIDE_EFFECTS__*/
    function _createIs(theType) {
        return function (value) {
            return typeof value === theType;
        };
    }
    /*#__NO_SIDE_EFFECTS__*/
    function _createObjIs(theName) {
        var theType = "[object " + theName + "]";
        return function (value) {
            return !!(value && objToString(value) === theType);
        };
    }
    /*#__NO_SIDE_EFFECTS__*/
    function objToString(value) {
        return ObjProto.toString.call(value);
    }
    /*#__NO_SIDE_EFFECTS__*/
    function isUndefined(value) {
        return typeof value === UNDEFINED || value === UNDEFINED;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function isNullOrUndefined(value) {
        return value === NULL_VALUE || isUndefined(value);
    }
    var isString = ( /*#__PURE__*/_createIs(STRING));
    var isFunction = ( /*#__PURE__*/_createIs(FUNCTION));
    /*#__NO_SIDE_EFFECTS__*/
    function isObject(value) {
        if (!value && isNullOrUndefined(value)) {
            return false;
        }
        return !!value && typeof value === OBJECT;
    }
    var isArray = ArrCls.isArray;
    var isRegExp = ( /*#__PURE__*/_createObjIs("RegExp"));

    var objGetOwnPropertyDescriptor = ObjClass.getOwnPropertyDescriptor;

    /*#__NO_SIDE_EFFECTS__*/
    function objHasOwnProperty(obj, prop) {
        return !!obj && ObjProto.hasOwnProperty[CALL](obj, prop);
    }

    var objHasOwn = ObjClass["hasOwn"] || polyObjHasOwn;
    /*#__NO_SIDE_EFFECTS__*/
    function polyObjHasOwn(obj, prop) {
        return objHasOwnProperty(obj, prop) || !!objGetOwnPropertyDescriptor(obj, prop);
    }

    function objForEachKey(theObject, callbackfn, thisArg) {
        if (theObject && isObject(theObject)) {
            for (var prop in theObject) {
                if (objHasOwn(theObject, prop)) {
                    if (callbackfn[CALL](thisArg || theObject, prop, theObject[prop]) === -1) {
                        break;
                    }
                }
            }
        }
    }

    var objDefineProp = ObjClass["defineProperty"];

    /*#__NO_SIDE_EFFECTS__*/
    function createCachedValue(value) {
        return objDefineProp({
            toJSON: function () { return value; }
        }, "v", { value: value });
    }

    /*#__NO_SIDE_EFFECTS__*/
    function _createKeyValueMap(values, keyType, valueType, completeFn) {
        var theMap = {};
        objForEachKey(values, function (key, value) {
            theMap[key] = keyType ? value : key;
            theMap[value] = valueType ? value : key;
        });
        return completeFn(theMap);
    }

    /*#__NO_SIDE_EFFECTS__*/
    function polyObjKeys(obj) {
        if (!isObject(obj) || obj === NULL_VALUE) {
            throwTypeError("polyObjKeys called on non-object");
        }
        var result = [];
        for (var prop in obj) {
            if (objHasOwn(obj, prop)) {
                result.push(prop);
            }
        }
        return result;
    }

    var _objFreeze = ObjClass["freeze"];
    function _doNothing(value) {
        return value;
    }
    function objDeepFreeze(value) {
        if (_objFreeze) {
            objForEachKey(value, function (key, value) {
                if (isArray(value) || isObject(value)) {
                    _objFreeze(value);
                }
            });
        }
        return objFreeze(value);
    }
    var objFreeze = _objFreeze || _doNothing;

    /*#__NO_SIDE_EFFECTS__*/
    function createEnumKeyMap(values) {
        return _createKeyValueMap(values, 0 , 0 , objDeepFreeze);
    }

    var _wellKnownSymbolMap = /*#__PURE__*/ createEnumKeyMap({
        asyncIterator: 0 ,
        hasInstance: 1 ,
        isConcatSpreadable: 2 ,
        iterator: 3 ,
        match: 4 ,
        matchAll: 5 ,
        replace: 6 ,
        search: 7 ,
        species: 8 ,
        split: 9 ,
        toPrimitive: 10 ,
        toStringTag: 11 ,
        unscopables: 12
    });

    var GLOBAL_CONFIG_KEY = "__tsUtils$gblCfg";
    var _globalCfg;
    function _getGlobalValue() {
        var result;
        if (typeof globalThis !== UNDEFINED) {
            result = globalThis;
        }
        if (!result && typeof self !== UNDEFINED) {
            result = self;
        }
        if (!result && typeof window !== UNDEFINED) {
            result = window;
        }
        if (!result && typeof global !== UNDEFINED) {
            result = global;
        }
        return result;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function _getGlobalConfig() {
        if (!_globalCfg) {
            var gbl = safe(_getGlobalValue).v || {};
            _globalCfg = gbl[GLOBAL_CONFIG_KEY] = gbl[GLOBAL_CONFIG_KEY] || {};
        }
        return _globalCfg;
    }

    var mathMax = MathCls.max;

    var strSlice = ( /*#__PURE__*/_unwrapFunction(SLICE, StrProto));

    var strSubstring = ( /*#__PURE__*/_unwrapFunction("substring", StrProto));
    /*#__NO_SIDE_EFFECTS__*/
    function polyStrSubstr(value, start, length) {
        if (isNullOrUndefined(value)) {
            throwTypeError("'polyStrSubstr called with invalid " + dumpObj(value));
        }
        if (length < 0) {
            return EMPTY;
        }
        start = start || 0;
        if (start < 0) {
            start = mathMax(start + value[LENGTH], 0);
        }
        if (isUndefined(length)) {
            return strSlice(value, start);
        }
        return strSlice(value, start, start + length);
    }

    var _wellKnownSymbolCache;
    /*#__NO_SIDE_EFFECTS__*/
    function polyNewSymbol(description) {
        var theSymbol = {
            description: asString(description),
            toString: function () { return SYMBOL + "(" + description + ")"; }
        };
        theSymbol[POLYFILL_TAG] = true;
        return theSymbol;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function polyGetKnownSymbol(name) {
        !_wellKnownSymbolCache && (_wellKnownSymbolCache = {});
        var result;
        var knownName = _wellKnownSymbolMap[name];
        if (knownName) {
            result = _wellKnownSymbolCache[knownName] = _wellKnownSymbolCache[knownName] || polyNewSymbol(SYMBOL + "." + knownName);
        }
        return result;
    }

    var _globalLazyTestHooks;
    function _initTestHooks() {
        _globalLazyTestHooks = _getGlobalConfig();
    }
    function getLazy(cb) {
        var lazyValue = {};
        !_globalLazyTestHooks && _initTestHooks();
        lazyValue.b = _globalLazyTestHooks.lzy;
        objDefineProp(lazyValue, "v", {
            configurable: true,
            get: function () {
                var result = cb();
                if (!_globalLazyTestHooks.lzy) {
                    objDefineProp(lazyValue, "v", {
                        value: result
                    });
                }
                lazyValue.b = _globalLazyTestHooks.lzy;
                return result;
            }
        });
        return lazyValue;
    }

    var WINDOW = "window";
    var _cachedWindow;
    /*#__NO_SIDE_EFFECTS__*/
    function lazySafeGetInst(name) {
        return getLazy(function () { return safe((getInst), [name]).v || UNDEF_VALUE; });
    }
    /*#__NO_SIDE_EFFECTS__*/
    function getInst(name, useCached) {
        if (name === WINDOW && _cachedWindow) {
            return _cachedWindow.v;
        }
        return NULL_VALUE;
    }

    var _symbol;
    function _initSymbol() {
        if (!_symbol || !_symbol.b) {
            _symbol = lazySafeGetInst(SYMBOL);
        }
    }
    /*#__NO_SIDE_EFFECTS__*/
    function getKnownSymbol(name, noPoly) {
        var knownName = _wellKnownSymbolMap[name];
        !_globalLazyTestHooks && _initTestHooks();
        (!_symbol || _globalLazyTestHooks.lzy) && _initSymbol();
        return _symbol.v ? _symbol.v[knownName || name] : (!noPoly ? polyGetKnownSymbol(name) : UNDEF_VALUE);
    }

    /*#__NO_SIDE_EFFECTS__*/
    function isIterator(value) {
        return !!value && isFunction(value.next);
    }

    var _iterSymbol;
    function iterForOf(iter, callbackfn, thisArg) {
        if (iter) {
            if (!isIterator(iter)) {
                !_iterSymbol && (_iterSymbol = createCachedValue(getKnownSymbol(3 )));
                iter = iter[_iterSymbol.v] ? iter[_iterSymbol.v]() : null;
            }
            if (isIterator(iter)) {
                var err = void 0;
                var iterResult = void 0;
                try {
                    var count = 0;
                    while (!(iterResult = iter.next())[DONE]) {
                        if (callbackfn[CALL](thisArg || iter, iterResult[VALUE], count, iter) === -1) {
                            break;
                        }
                        count++;
                    }
                }
                catch (failed) {
                    err = { e: failed };
                    if (iter.throw) {
                        iterResult = null;
                        iter.throw(err);
                    }
                }
                finally {
                    try {
                        if (iterResult && !iterResult[DONE]) {
                            iter.return && iter.return(iterResult);
                        }
                    }
                    finally {
                        if (err) {
                            throw err.e;
                        }
                    }
                }
            }
        }
    }

    /*#__NO_SIDE_EFFECTS__*/
    function polyIsArray(value) {
        if (isNullOrUndefined(value)) {
            return false;
        }
        return objToString(value) === "[object Array]";
    }
    /*#__NO_SIDE_EFFECTS__*/
    function polyArrIncludes(theArray, searchElement, fromIndex) {
        return arrIndexOf(theArray, searchElement, fromIndex) !== -1;
    }
    function polyArrFind(theArray, callbackFn, thisArg) {
        var result;
        var idx = polyArrFindIndex(theArray, callbackFn, thisArg);
        return idx !== -1 ? theArray[idx] : result;
    }
    function polyArrFindIndex(theArray, callbackFn, thisArg) {
        var result = -1;
        arrForEach(theArray, function (value, index) {
            if (callbackFn[CALL](thisArg | theArray, value, index, theArray)) {
                result = index;
                return -1;
            }
        });
        return result;
    }
    function polyArrFindLast(theArray, callbackFn, thisArg) {
        var result;
        var idx = polyArrFindLastIndex(theArray, callbackFn, thisArg);
        return idx !== -1 ? theArray[idx] : result;
    }
    function polyArrFindLastIndex(theArray, callbackFn, thisArg) {
        var result = -1;
        var len = theArray[LENGTH] >>> 0;
        for (var idx = len - 1; idx >= 0; idx--) {
            if (idx in theArray && callbackFn[CALL](thisArg | theArray, theArray[idx], idx, theArray)) {
                result = idx;
                break;
            }
        }
        return result;
    }
    function polyArrFrom(theValue, mapFn, thisArg) {
        if (isArray(theValue)) {
            var result_1 = arrSlice(theValue);
            return mapFn ? arrMap(result_1, mapFn, thisArg) : result_1;
        }
        var result = [];
        iterForOf(theValue, function (value, cnt) {
            return result.push(mapFn ? mapFn[CALL](thisArg, value, cnt) : value);
        });
        return result;
    }

    /*#__NO_SIDE_EFFECTS__*/
    function polyStrStartsWith(value, searchString, position) {
        if (!isString(value)) {
            throwTypeError("'" + dumpObj(value) + "' is not a string");
        }
        var searchValue = isString(searchString) ? searchString : asString(searchString);
        var pos = position > 0 ? position : 0;
        return strSubstring(value, pos, pos + searchValue[LENGTH]) === searchValue;
    }

    /*#__NO_SIDE_EFFECTS__*/
    function polyStrEndsWith(value, searchString, length) {
        if (!isString(value)) {
            throwTypeError("'" + dumpObj(value) + "' is not a string");
        }
        var searchValue = isString(searchString) ? searchString : asString(searchString);
        var end = !isUndefined(length) && length < value[LENGTH] ? length : value[LENGTH];
        return strSubstring(value, end - searchValue[LENGTH], end) === searchValue;
    }

    /*#__NO_SIDE_EFFECTS__*/
    function _createTrimFn(exp) {
        return function _doTrim(value) {
            if (isNullOrUndefined(value)) {
                throwTypeError("strTrim called [" + dumpObj(value) + "]");
            }
            if (value && value.replace) {
                value = value.replace(exp, EMPTY);
            }
            return value;
        };
    }
    var polyStrTrim = ( /*#__PURE__*/_createTrimFn(/^\s+|(?=\s)\s+$/g));
    var polyStrTrimStart = ( /*#__PURE__*/_createTrimFn(/^\s+/g));
    var polyStrTrimEnd = ( /*#__PURE__*/_createTrimFn(/(?=\s)\s+$/g));

    var mathFloor = MathCls.floor;
    var mathCeil = MathCls.ceil;

    var mathTrunc = MathCls.trunc || polyMathTrunc;
    /*#__NO_SIDE_EFFECTS__*/
    function polyMathTrunc(value) {
        var theValue = +value;
        return (theValue > 0 ? mathFloor : mathCeil)(theValue);
    }

    /*#__NO_SIDE_EFFECTS__*/
    function mathToInt(value, throwInfinity) {
        var result = +value;
        if (result == Infinity && throwInfinity) {
            throwRangeError("invalid value [" + dumpObj(value) + "]");
        }
        return result !== result || result === 0 ? 0 : mathTrunc(result);
    }

    var strRepeat = ( /*#__PURE__*/_unwrapFunctionWithPoly("repeat", StrProto, polyStrRepeat));
    /*#__NO_SIDE_EFFECTS__*/
    function polyStrRepeat(value, count) {
        if (isNullOrUndefined(value)) {
            throwTypeError("can't convert [" + dumpObj(value) + "]");
        }
        count = mathToInt(count, true);
        if (count < 0) {
            throwRangeError("invalid count must be >= 0 && < Infinity");
        }
        var pad = isString(value) ? value : asString(value);
        var result = EMPTY;
        for (; count > 0; (count >>>= 1) && (pad += pad)) {
            if (count & 1) {
                result += pad;
            }
        }
        return result;
    }

    /*#__NO_SIDE_EFFECTS__*/
    function _padValue(value, targetLength, padString) {
        var result = EMPTY;
        targetLength = mathToInt(targetLength, true);
        targetLength >>= 0;
        var len = value[LENGTH];
        if (len < targetLength) {
            result = isNullOrUndefined(padString) ? " " : asString(padString);
            targetLength = targetLength - len;
            if (targetLength > result[LENGTH]) {
                result = strRepeat(result, mathCeil(targetLength / result[LENGTH]));
            }
            if (result[LENGTH] > targetLength) {
                result = strSubstring(result, 0, targetLength);
            }
        }
        return result;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function polyStrPadStart(value, targetLength, padString) {
        return _padValue(value, targetLength, padString) + value;
    }
    /*#__NO_SIDE_EFFECTS__*/
    function polyStrPadEnd(value, targetLength, padString) {
        return value + _padValue(value, targetLength, padString);
    }

    /*#__NO_SIDE_EFFECTS__*/
    function makePolyFn(poly) {
        return function () {
            var theArgs = [this];
            for (var lp = 0; lp < arguments[LENGTH]; lp++) {
                theArgs[lp + 1] = arguments[lp];
            }
            return poly.apply(this, theArgs);
        };
    }

    var strIndexOf = ( /*#__PURE__*/_unwrapFunction(INDEX_OF, StrProto));

    /*#__NO_SIDE_EFFECTS__*/
    function polyStrIncludes(value, searchString, position) {
        if (isRegExp(searchString)) {
            throwTypeError("'searchString' must not be a regular expression" + dumpObj(searchString));
        }
        return strIndexOf(value, asString(searchString), position) !== -1;
    }

    (function () {
        var objectPolyfills = {
            "keys": polyObjKeys,
            "hasOwn": polyObjHasOwn
        };
        var stringPolyfills = {
            "startsWith": polyStrStartsWith,
            "endsWith": polyStrEndsWith,
            "padStart": polyStrPadStart,
            "padEnd": polyStrPadEnd,
            "trim": polyStrTrim,
            "trimStart": polyStrTrimStart,
            "trimLeft": polyStrTrimStart,
            "trimEnd": polyStrTrimEnd,
            "trimRight": polyStrTrimEnd,
            "substr": polyStrSubstr,
            "includes": polyStrIncludes
        };
        var arrayClsPolyfills = {
            "isArray": polyIsArray,
            "from": polyArrFrom
        };
        var arrayPolyfills = {
            "includes": polyArrIncludes,
            "find": polyArrFind,
            "findIndex": polyArrFindIndex,
            "findLast": polyArrFindLast,
            "findLastIndex": polyArrFindLastIndex
        };
        arrForEach(polyObjKeys(objectPolyfills), function (key) {
            if (!ObjClass[key]) {
                ObjClass[key] = makePolyFn(objectPolyfills[key]);
            }
        });
        arrForEach(polyObjKeys(arrayClsPolyfills), function (key) {
            if (!ArrCls[key]) {
                ArrCls[key] = makePolyFn(arrayClsPolyfills[key]);
            }
        });
        arrForEach(polyObjKeys(arrayPolyfills), function (key) {
            if (!ArrProto[key]) {
                ArrProto[key] = makePolyFn(arrayPolyfills[key]);
            }
        });
        arrForEach(polyObjKeys(stringPolyfills), function (key) {
            if (!StrProto[key]) {
                StrProto[key] = makePolyFn(stringPolyfills[key]);
            }
        });
    })();

})();
//# sourceMappingURL=ts-polyfills-utils.js.map
