"use strict";

var _agent = require("../loaders/agent");
var _instrument = require("../features/page_view_event/instrument");
var _instrument2 = require("../features/page_view_timing/instrument");
var _instrument3 = require("../features/metrics/instrument");
var _instrument4 = require("../features/jserrors/instrument");
var _instrument5 = require("../features/ajax/instrument");
var _instrument6 = require("../features/session_trace/instrument");
var _instrument7 = require("../features/session_replay/instrument");
var _instrument8 = require("../features/soft_navigations/instrument");
var _instrument9 = require("../features/page_action/instrument");
/*
 * Copyright 2023 New Relic Corporation. All rights reserved.
 * SPDX-License-Identifier: Apache-2.0
 */
/**
 * @file Creates an "EXPERIMENTAL" agent loader bundle composed of the core agent and all available feature modules, including experimental features.
 *
 * NOTE: This loader is ONLY used for internal testing. The code contained within is likely under development and dormant. It will not download to instrumented pages or record any data.
 * It is not production ready, and is not intended to be imported or implemented in any build of the browser agent
 */

// import { Instrument as InstrumentSpa } from '../features/spa/instrument'

new _agent.Agent({
  features: [_instrument5.Instrument, _instrument.Instrument, _instrument2.Instrument, _instrument6.Instrument, _instrument7.Instrument, _instrument3.Instrument, _instrument9.Instrument, _instrument4.Instrument,
  // InstrumentSpa,
  _instrument8.Instrument],
  loaderType: 'experimental'
});