"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "getConfiguration", {
  enumerable: true,
  get: function () {
    return _init.getConfiguration;
  }
});
Object.defineProperty(exports, "getConfigurationValue", {
  enumerable: true,
  get: function () {
    return _init.getConfigurationValue;
  }
});
Object.defineProperty(exports, "getInfo", {
  enumerable: true,
  get: function () {
    return _info.getInfo;
  }
});
Object.defineProperty(exports, "getLoaderConfig", {
  enumerable: true,
  get: function () {
    return _loaderConfig.getLoaderConfig;
  }
});
Object.defineProperty(exports, "getRuntime", {
  enumerable: true,
  get: function () {
    return _runtime.getRuntime;
  }
});
exports.isConfigured = isConfigured;
Object.defineProperty(exports, "originals", {
  enumerable: true,
  get: function () {
    return _originals.originals;
  }
});
Object.defineProperty(exports, "setConfiguration", {
  enumerable: true,
  get: function () {
    return _init.setConfiguration;
  }
});
Object.defineProperty(exports, "setInfo", {
  enumerable: true,
  get: function () {
    return _info.setInfo;
  }
});
Object.defineProperty(exports, "setLoaderConfig", {
  enumerable: true,
  get: function () {
    return _loaderConfig.setLoaderConfig;
  }
});
Object.defineProperty(exports, "setRuntime", {
  enumerable: true,
  get: function () {
    return _runtime.setRuntime;
  }
});
var _info = require("./state/info");
var _init = require("./state/init");
var _loaderConfig = require("./state/loader-config");
var _originals = require("./state/originals");
var _runtime = require("./state/runtime");
function isConfigured(agentIdentifier) {
  return (0, _info.isValid)(agentIdentifier);
}

// This module acts as a hub that bundles the static and dynamic properties used by each agent instance into one single interface