"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInfo = getInfo;
exports.isValid = isValid;
exports.setInfo = setInfo;
var _nreum = require("../../window/nreum");
var _configurable = require("./configurable");
const model = {
  // preset defaults
  beacon: _nreum.defaults.beacon,
  errorBeacon: _nreum.defaults.errorBeacon,
  // others must be populated by user
  licenseKey: undefined,
  applicationID: undefined,
  sa: undefined,
  queueTime: undefined,
  applicationTime: undefined,
  ttGuid: undefined,
  user: undefined,
  account: undefined,
  product: undefined,
  extra: undefined,
  jsAttributes: {},
  userAttributes: undefined,
  atts: undefined,
  transactionName: undefined,
  tNamePlain: undefined
};
const _cache = {};
function isValid(id) {
  try {
    const info = getInfo(id);
    return !!info.licenseKey && !!info.errorBeacon && !!info.applicationID;
  } catch (err) {
    return false;
  }
}
function getInfo(id) {
  if (!id) throw new Error('All info objects require an agent identifier!');
  if (!_cache[id]) throw new Error("Info for ".concat(id, " was never set"));
  return _cache[id];
}
function setInfo(id, obj) {
  if (!id) throw new Error('All info objects require an agent identifier!');
  _cache[id] = (0, _configurable.getModeledObject)(obj, model);
  const agentInst = (0, _nreum.getNREUMInitializedAgent)(id);
  if (agentInst) agentInst.info = _cache[id];
}