"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLoaderConfig = getLoaderConfig;
exports.setLoaderConfig = setLoaderConfig;
var _nreum = require("../../window/nreum");
var _configurable = require("./configurable");
const model = {
  accountID: undefined,
  trustKey: undefined,
  agentID: undefined,
  licenseKey: undefined,
  applicationID: undefined,
  xpid: undefined
};
const _cache = {};
function getLoaderConfig(id) {
  if (!id) throw new Error('All loader-config objects require an agent identifier!');
  if (!_cache[id]) throw new Error("LoaderConfig for ".concat(id, " was never set"));
  return _cache[id];
}
function setLoaderConfig(id, obj) {
  if (!id) throw new Error('All loader-config objects require an agent identifier!');
  _cache[id] = (0, _configurable.getModeledObject)(obj, model);
  const agentInst = (0, _nreum.getNREUMInitializedAgent)(id);
  if (agentInst) agentInst.loader_config = _cache[id];
}