"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRuntime = getRuntime;
exports.setRuntime = setRuntime;
var _configurable = require("./configurable");
var _nreum = require("../../window/nreum");
var _runtime = require("../../constants/runtime");
var _env = require("../../constants/env.npm");
const model = {
  buildEnv: _env.BUILD_ENV,
  customTransaction: undefined,
  disabled: false,
  distMethod: _env.DIST_METHOD,
  isolatedBacklog: false,
  loaderType: undefined,
  maxBytes: 30000,
  // The "timeOrigin" property is the new standard timestamp property shared across main frame and workers, but is not supported in some early Safari browsers (safari<15) + IE
  // ingest expects an integer value, and timeOrigin can return a float.
  offset: Math.floor(_runtime.globalScope?.performance?.timeOrigin || _runtime.globalScope?.performance?.timing?.navigationStart || Date.now()),
  onerror: undefined,
  origin: '' + _runtime.globalScope.location,
  ptid: undefined,
  releaseIds: {},
  /** Agent-specific metadata found in the RUM call response. ex. entityGuid */
  appMetadata: {},
  session: undefined,
  xhrWrappable: typeof _runtime.globalScope.XMLHttpRequest?.prototype?.addEventListener === 'function',
  version: _env.VERSION,
  denyList: undefined,
  harvestCount: 0
};
const _cache = {};
function getRuntime(id) {
  if (!id) throw new Error('All runtime objects require an agent identifier!');
  if (!_cache[id]) throw new Error("Runtime for ".concat(id, " was never set"));
  return _cache[id];
}
function setRuntime(id, obj) {
  if (!id) throw new Error('All runtime objects require an agent identifier!');
  _cache[id] = (0, _configurable.getModeledObject)(obj, model);
  const agentInst = (0, _nreum.getNREUMInitializedAgent)(id);
  if (agentInst) agentInst.runtime = _cache[id];
}